#include "translate.h"

static const t_unicode JIS0201_g0_chars[] = {
0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, /* 0x20-0x27 */
0x0028, 0x0029, 0x002A, 0x002B, 0x002C, 0x002D, 0x002E, 0x002F,	/* 0x28-0x2F */
0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,	/* 0x30-0x37 */
0x0038, 0x0039, 0x003A, 0x003B, 0x003C, 0x003D, 0x003E, 0x003F,	/* 0x38-0x3F */
0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,	/* 0x40-0x47 */
0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F,	/* 0x48-0x4F */
0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,	/* 0x50-0x57 */
0x0058, 0x0059, 0x005A, 0x005B, 0x00A5, 0x005D, 0x005E, 0x005F,	/* 0x58-0x5F */
0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,	/* 0x60-0x67 */
0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F,	/* 0x68-0x6F */
0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,	/* 0x70-0x77 */
0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D, 0x203E, 0x007F,	/* 0x78-0x7F */
};
struct char_set JIS0201_g0 = {
	1,
	CHARS(JIS0201_g0_chars),
	14, "J", 0, 94,
};
static const t_unicode JIS0201_g1_chars[] = {
0xfffd, 0xFF61, 0xFF62, 0xFF63, 0xFF64, 0xFF65, 0xFF66, 0xFF67, /* 0xA0-0xA7 */
0xFF68, 0xFF69, 0xFF6A, 0xFF6B, 0xFF6C, 0xFF6D, 0xFF6E, 0xFF6F, /* 0xA8-0xAF */
0xFF70, 0xFF71, 0xFF72, 0xFF73, 0xFF74, 0xFF75, 0xFF76, 0xFF77, /* 0xB0-0xB7 */
0xFF78, 0xFF79, 0xFF7A, 0xFF7B, 0xFF7C, 0xFF7D, 0xFF7E, 0xFF7F, /* 0xB8-0xBF */
0xFF80, 0xFF81, 0xFF82, 0xFF83, 0xFF84, 0xFF85, 0xFF86, 0xFF87, /* 0xC0-0xC7 */
0xFF88, 0xFF89, 0xFF8A, 0xFF8B, 0xFF8C, 0xFF8D, 0xFF8E, 0xFF8F, /* 0xC8-0xCF */
0xFF90, 0xFF91, 0xFF92, 0xFF93, 0xFF94, 0xFF95, 0xFF96, 0xFF97, /* 0xD0-0xD7 */
0xFF98, 0xFF99, 0xFF9A, 0xFF9B, 0xFF9C, 0xFF9D, 0xFF9E, 0xFF9F, /* 0xD8-0xDF */
0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, /* 0xE0-0xE7 */
0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, /* 0xE8-0xEF */
0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, /* 0xF0-0xF7 */
0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, /* 0xF8-0xFF */
};
struct char_set JIS0201_g1 = {
	1,
	CHARS(JIS0201_g1_chars),
	13, "I", 1, 96,
};

struct char_set JIS0201 = {
	.c0 = &ascii_c0,
	.g0 = &JIS0201_g0,
	.c1 = &ascii_c1,
	.g1 = &JIS0201_g1,
	.names = { "jisx0201", "jisc6220", "jisx0201.1976-0", 0 },
};

CONSTRUCTOR(static void init(void))
{
	register_charset(&JIS0201_g0);
	register_charset(&JIS0201_g1);
	register_charset(&JIS0201);
}
