/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.fileevents.internal;

import java.io.File;
import java.util.Collection;
import org.gradle.fileevents.FileWatcher;
import org.gradle.fileevents.internal.AbstractFileEventFunctions;

public abstract class AbstractNativeFileEventFunctions<W extends FileWatcher>
extends AbstractFileEventFunctions<W> {
    public static String getVersion() {
        return AbstractNativeFileEventFunctions.getVersion0();
    }

    private static native String getVersion0();

    protected static abstract class NativeFileWatcher
    extends AbstractFileEventFunctions.AbstractFileWatcher {
        protected final Object server;

        public NativeFileWatcher(Object server, AbstractFileEventFunctions.NativeFileWatcherCallback callback) {
            super(callback);
            this.server = server;
        }

        @Override
        protected void initializeRunLoop() {
            this.initializeRunLoop0(this.server);
        }

        private native void initializeRunLoop0(Object var1);

        @Override
        protected void executeRunLoop() {
            this.executeRunLoop0(this.server);
        }

        private native void executeRunLoop0(Object var1);

        @Override
        protected void doStartWatching(Collection<File> paths) {
            this.startWatching0(this.server, NativeFileWatcher.toAbsolutePaths(paths));
        }

        private native void startWatching0(Object var1, String[] var2);

        @Override
        protected boolean doStopWatching(Collection<File> paths) {
            return this.stopWatching0(this.server, NativeFileWatcher.toAbsolutePaths(paths));
        }

        private native boolean stopWatching0(Object var1, String[] var2);

        protected static String[] toAbsolutePaths(Collection<File> files) {
            String[] paths = new String[files.size()];
            int index = 0;
            for (File file : files) {
                paths[index++] = file.getAbsolutePath();
            }
            return paths;
        }

        @Override
        protected void doShutdown() {
            this.shutdown0(this.server);
        }

        private native void shutdown0(Object var1);

        @Override
        protected boolean awaitTermination(long timeoutInMillis) {
            return this.awaitTermination0(this.server, timeoutInMillis);
        }

        private native boolean awaitTermination0(Object var1, long var2);
    }
}

