/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.toolchain;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.gradle.api.resources.ResourceException;
import org.gradle.internal.logging.progress.ProgressLoggingInputStream;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ResourceExceptions;
import org.gradle.internal.resource.transfer.ExternalResourceReadResponse;
import org.gradle.internal.resource.transport.http.HttpClientHelper;
import org.gradle.internal.resource.transport.http.HttpResourceAccessor;
import org.gradle.internal.resource.transport.http.HttpResponseResource;
import org.gradle.internal.time.Clock;
import org.gradle.launcher.daemon.toolchain.DownloadProgressListener;

public class ToolchainExternalResourceAccessor
extends HttpResourceAccessor {
    private final DownloadProgressListener downloadProgressListener;
    private final Clock clock;

    public ToolchainExternalResourceAccessor(HttpClientHelper httpClientHelper, Clock clock, DownloadProgressListener downloadProgressListener) {
        super(httpClientHelper);
        this.clock = clock;
        this.downloadProgressListener = downloadProgressListener;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public <T> T withContent(ExternalResourceName location, boolean revalidate, ExternalResource.ContentAndMetadataAction<T> action) throws ResourceException {
        HttpResponseResource response = this.openResource(location, revalidate);
        if (response == null) {
            return null;
        }
        long startTime = this.clock.getCurrentTime();
        AtomicLong downloadedBytes = new AtomicLong(0L);
        try (InputStream inputStream = response.openStream();){
            Object object;
            block15: {
                HttpResponseResource responseCloser = response;
                try {
                    ProgressLoggingInputStream progressLoggingInputStream = new ProgressLoggingInputStream(inputStream, arg_0 -> this.lambda$withContent$0(downloadedBytes, location, (ExternalResourceReadResponse)response, startTime, arg_0));
                    object = action.execute((InputStream)progressLoggingInputStream, responseCloser.getMetaData());
                    if (responseCloser == null) break block15;
                }
                catch (Throwable throwable) {
                    if (responseCloser != null) {
                        try {
                            responseCloser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                responseCloser.close();
            }
            return (T)object;
        }
        catch (Exception e) {
            this.downloadProgressListener.downloadFailed(location.getUri(), e, downloadedBytes.get(), startTime, this.clock.getCurrentTime());
            throw ResourceExceptions.getFailed((URI)location.getUri(), (Throwable)e);
        }
    }

    private /* synthetic */ void lambda$withContent$0(AtomicLong downloadedBytes, ExternalResourceName location, ExternalResourceReadResponse response, long startTime, int processedBytes) throws IOException {
        if (downloadedBytes.get() == 0L) {
            this.downloadProgressListener.downloadStarted(location.getUri(), response.getMetaData().getContentLength(), startTime);
        }
        downloadedBytes.addAndGet(processedBytes);
        this.downloadProgressListener.downloadStatusChanged(location.getUri(), downloadedBytes.get(), response.getMetaData().getContentLength(), this.clock.getCurrentTime());
        if (downloadedBytes.get() == response.getMetaData().getContentLength()) {
            this.downloadProgressListener.downloadFinished(location.getUri(), downloadedBytes.get(), startTime, this.clock.getCurrentTime());
        }
    }
}

