/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit.result;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.gradle.api.internal.tasks.testing.junit.result.JUnitXmlResultOptions;
import org.gradle.api.internal.tasks.testing.junit.result.TestClassResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestMethodResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestResultsProvider;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableFailure;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.xml.SimpleXmlWriter;

public class JUnitXmlResultWriter {
    private final String hostName;
    private final TestResultsProvider testResultsProvider;
    private final JUnitXmlResultOptions options;

    public JUnitXmlResultWriter(String hostName, TestResultsProvider testResultsProvider, JUnitXmlResultOptions options) {
        this.hostName = hostName;
        this.testResultsProvider = testResultsProvider;
        this.options = options;
    }

    public void write(TestClassResult result, OutputStream output) {
        long classId = result.getId();
        try {
            SimpleXmlWriter writer = new SimpleXmlWriter(output, "  ");
            writer.startElement("testsuite").attribute("name", result.getXmlTestSuiteName()).attribute("tests", String.valueOf(result.getTestsCount())).attribute("skipped", String.valueOf(result.getSkippedCount())).attribute("failures", String.valueOf(result.getFailuresCount())).attribute("errors", "0").attribute("timestamp", DateTimeFormatter.ISO_INSTANT.format(Instant.ofEpochMilli(result.getStartTime()))).attribute("hostname", this.hostName).attribute("time", String.valueOf((double)result.getDuration() / 1000.0));
            writer.startElement("properties");
            writer.endElement();
            List<TestMethodResult> methodResults = result.getResults();
            String className = result.getClassName();
            if (this.options.mergeReruns) {
                this.writeTestCasesWithMergeRerunHandling(writer, methodResults, className, classId);
            } else {
                this.writeTestCasesWithDiscreteRerunHandling(writer, methodResults, className, classId);
            }
            if (this.options.includeSystemOutLog) {
                writer.startElement("system-out");
                this.writeOutputs(writer, classId, !this.options.outputPerTestCase, TestOutputEvent.Destination.StdOut);
                writer.endElement();
            }
            if (this.options.includeSystemErrLog) {
                writer.startElement("system-err");
                this.writeOutputs(writer, classId, !this.options.outputPerTestCase, TestOutputEvent.Destination.StdErr);
                writer.endElement();
            }
            writer.endElement();
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private void writeOutputs(SimpleXmlWriter writer, long classId, boolean allClassOutput, TestOutputEvent.Destination destination) throws IOException {
        writer.startCDATA();
        if (allClassOutput) {
            this.testResultsProvider.writeAllOutput(classId, destination, (Writer)writer);
        } else {
            this.testResultsProvider.writeNonTestOutput(classId, destination, (Writer)writer);
        }
        writer.endCDATA();
    }

    private void writeTestCasesWithMergeRerunHandling(SimpleXmlWriter writer, Iterable<TestMethodResult> methodResults, String className, long classId) throws IOException {
        List<List<TestMethodResult>> groupedExecutions = this.groupExecutions(methodResults);
        for (List<TestMethodResult> groupedExecution : groupedExecutions) {
            if (groupedExecution.size() == 1) {
                this.writeTestCase(writer, this.discreteTestCase(className, classId, groupedExecution.get(0)));
                continue;
            }
            TestMethodResult firstExecution = groupedExecution.get(0);
            TestMethodResult lastExecution = groupedExecution.get(groupedExecution.size() - 1);
            boolean allFailed = lastExecution.getResultType() == TestResult.ResultType.FAILURE;
            long duration = allFailed ? firstExecution.getDuration() : lastExecution.getDuration();
            this.writeTestCase(writer, new TestCase(firstExecution.getDisplayName(), className, duration, this.mergeRerunExecutions(allFailed, groupedExecution, firstExecution, classId)));
        }
    }

    private Iterable<TestCaseExecution> mergeRerunExecutions(final boolean allFailed, List<TestMethodResult> groupedExecution, final TestMethodResult firstExecution, final long classId) {
        return Iterables.concat((Iterable)Iterables.transform(groupedExecution, (Function)new Function<TestMethodResult, Iterable<? extends TestCaseExecution>>(){

            public Iterable<? extends TestCaseExecution> apply(TestMethodResult execution) {
                switch (execution.getResultType()) {
                    case SUCCESS: {
                        return Collections.singleton(JUnitXmlResultWriter.this.success(classId, execution.getId()));
                    }
                    case SKIPPED: {
                        return Collections.singleton(JUnitXmlResultWriter.this.skipped(classId, execution.getId(), execution.getAssumptionFailure()));
                    }
                    case FAILURE: {
                        return JUnitXmlResultWriter.this.failures(classId, execution, allFailed ? (execution == firstExecution ? FailureType.FAILURE : FailureType.RERUN_FAILURE) : FailureType.FLAKY_FAILURE);
                    }
                }
                throw new IllegalStateException("unhandled type: " + execution.getResultType());
            }
        }));
    }

    private List<List<TestMethodResult>> groupExecutions(Iterable<TestMethodResult> methodResults) {
        ArrayList<List<TestMethodResult>> groupedExecutions = new ArrayList<List<TestMethodResult>>();
        HashMap<String, Integer> latestGroupForName = new HashMap<String, Integer>();
        for (TestMethodResult methodResult : methodResults) {
            ArrayList<TestMethodResult> executions;
            String name = methodResult.getDisplayName();
            Integer index = (Integer)latestGroupForName.get(name);
            if (index == null) {
                executions = Collections.singletonList(methodResult);
                groupedExecutions.add(executions);
                if (methodResult.getResultType() != TestResult.ResultType.FAILURE) continue;
                latestGroupForName.put(name, groupedExecutions.size() - 1);
                continue;
            }
            executions = (ArrayList<TestMethodResult>)groupedExecutions.get(index);
            if (executions.size() == 1) {
                executions = new ArrayList<TestMethodResult>(executions);
                groupedExecutions.set(index, executions);
            }
            executions.add(methodResult);
            if (methodResult.getResultType() == TestResult.ResultType.FAILURE) continue;
            latestGroupForName.remove(name);
        }
        return groupedExecutions;
    }

    private void writeTestCasesWithDiscreteRerunHandling(SimpleXmlWriter writer, Iterable<TestMethodResult> methodResults, String className, long classId) throws IOException {
        for (TestMethodResult methodResult : methodResults) {
            this.writeTestCase(writer, this.discreteTestCase(className, classId, methodResult));
        }
    }

    private TestCase discreteTestCase(String className, long classId, TestMethodResult methodResult) {
        return new TestCase(methodResult.getDisplayName(), className, methodResult.getDuration(), this.discreteTestCaseExecutions(classId, methodResult));
    }

    private Iterable<? extends TestCaseExecution> discreteTestCaseExecutions(long classId, TestMethodResult methodResult) {
        switch (methodResult.getResultType()) {
            case FAILURE: {
                return this.failures(classId, methodResult, FailureType.FAILURE);
            }
            case SKIPPED: {
                return Collections.singleton(this.skipped(classId, methodResult.getId(), methodResult.getAssumptionFailure()));
            }
            case SUCCESS: {
                return Collections.singleton(this.success(classId, methodResult.getId()));
            }
        }
        throw new IllegalStateException("Unexpected result type: " + methodResult.getResultType());
    }

    private void writeTestCase(SimpleXmlWriter writer, TestCase testCase) throws IOException {
        writer.startElement("testcase").attribute("name", testCase.name).attribute("classname", testCase.className).attribute("time", String.valueOf((double)testCase.duration / 1000.0));
        for (TestCaseExecution testCaseExecution : testCase.executions) {
            testCaseExecution.write(writer);
        }
        writer.endElement();
    }

    private TestCaseExecution success(long classId, long id) {
        return new TestCaseExecutionSuccess(this.outputProvider(classId, id), this.options);
    }

    private TestCaseExecution skipped(long classId, long id, SerializableFailure assumptionFailure) {
        return new TestCaseExecutionSkipped(this.outputProvider(classId, id), this.options, assumptionFailure);
    }

    private Iterable<TestCaseExecution> failures(final long classId, final TestMethodResult methodResult, final FailureType failureType) {
        List<SerializableFailure> failures = methodResult.getFailures();
        if (failures.isEmpty()) {
            return Collections.emptyList();
        }
        final SerializableFailure firstFailure = failures.get(0);
        return Iterables.transform(failures, (Function)new Function<SerializableFailure, TestCaseExecution>(){

            public TestCaseExecution apply(SerializableFailure failure) {
                boolean isFirst = failure == firstFailure;
                OutputProvider outputProvider = isFirst ? JUnitXmlResultWriter.this.outputProvider(classId, methodResult.getId()) : NullOutputProvider.INSTANCE;
                return new TestCaseExecutionFailure(outputProvider, JUnitXmlResultWriter.this.options, failureType, failure);
            }
        });
    }

    private OutputProvider outputProvider(long classId, long id) {
        return this.options.outputPerTestCase ? new BackedOutputProvider(classId, id) : NullOutputProvider.INSTANCE;
    }

    static interface OutputProvider {
        public boolean has(TestOutputEvent.Destination var1);

        public void write(TestOutputEvent.Destination var1, Writer var2);
    }

    static enum FailureType {
        FAILURE("failure", false),
        FLAKY_FAILURE("flakyFailure", true),
        RERUN_FAILURE("rerunFailure", true);

        private final String elementName;
        private final boolean useStacktraceElementAndNestedOutput;

        private FailureType(String elementName, boolean useStacktraceElementAndNestedOutput) {
            this.elementName = elementName;
            this.useStacktraceElementAndNestedOutput = useStacktraceElementAndNestedOutput;
        }
    }

    static abstract class TestCaseExecution {
        private final OutputProvider outputProvider;
        private final JUnitXmlResultOptions options;

        TestCaseExecution(OutputProvider outputProvider, JUnitXmlResultOptions options) {
            this.outputProvider = outputProvider;
            this.options = options;
        }

        abstract void write(SimpleXmlWriter var1) throws IOException;

        protected void writeOutput(SimpleXmlWriter writer) throws IOException {
            if (this.options.includeSystemOutLog && this.outputProvider.has(TestOutputEvent.Destination.StdOut)) {
                writer.startElement("system-out");
                writer.startCDATA();
                this.outputProvider.write(TestOutputEvent.Destination.StdOut, (Writer)writer);
                writer.endCDATA();
                writer.endElement();
            }
            if (this.options.includeSystemErrLog && this.outputProvider.has(TestOutputEvent.Destination.StdErr)) {
                writer.startElement("system-err");
                writer.startCDATA();
                this.outputProvider.write(TestOutputEvent.Destination.StdErr, (Writer)writer);
                writer.endCDATA();
                writer.endElement();
            }
        }
    }

    private static class TestCase {
        final String name;
        final String className;
        final long duration;
        final Iterable<? extends TestCaseExecution> executions;

        TestCase(String name, String className, long duration, Iterable<? extends TestCaseExecution> executions) {
            this.name = name;
            this.className = className;
            this.duration = duration;
            this.executions = executions;
        }
    }

    private static class TestCaseExecutionSuccess
    extends TestCaseExecution {
        TestCaseExecutionSuccess(OutputProvider outputProvider, JUnitXmlResultOptions options) {
            super(outputProvider, options);
        }

        @Override
        public void write(SimpleXmlWriter writer) throws IOException {
            this.writeOutput(writer);
        }
    }

    private static class TestCaseExecutionSkipped
    extends TestCaseExecution {
        private final SerializableFailure assumptionFailure;

        TestCaseExecutionSkipped(OutputProvider outputProvider, JUnitXmlResultOptions options, SerializableFailure assumptionFailure) {
            super(outputProvider, options);
            this.assumptionFailure = assumptionFailure;
        }

        @Override
        public void write(SimpleXmlWriter writer) throws IOException {
            writer.startElement("skipped");
            if (this.assumptionFailure != null) {
                writer.attribute("message", this.assumptionFailure.getMessage());
                writer.attribute("type", this.assumptionFailure.getExceptionType());
                writer.write(this.assumptionFailure.getStackTrace());
            }
            writer.endElement();
            this.writeOutput(writer);
        }
    }

    class BackedOutputProvider
    implements OutputProvider {
        private final long classId;
        private final long testId;

        public BackedOutputProvider(long classId, long testId) {
            this.classId = classId;
            this.testId = testId;
        }

        @Override
        public boolean has(TestOutputEvent.Destination destination) {
            return JUnitXmlResultWriter.this.testResultsProvider.hasOutput(this.classId, this.testId, destination);
        }

        @Override
        public void write(TestOutputEvent.Destination destination, Writer writer) {
            JUnitXmlResultWriter.this.testResultsProvider.writeTestOutput(this.classId, this.testId, destination, writer);
        }
    }

    static class NullOutputProvider
    implements OutputProvider {
        static final OutputProvider INSTANCE = new NullOutputProvider();

        NullOutputProvider() {
        }

        @Override
        public boolean has(TestOutputEvent.Destination destination) {
            return false;
        }

        @Override
        public void write(TestOutputEvent.Destination destination, Writer writer) {
            throw new UnsupportedOperationException();
        }
    }

    private static class TestCaseExecutionFailure
    extends TestCaseExecution {
        private final SerializableFailure failure;
        private final FailureType type;

        TestCaseExecutionFailure(OutputProvider outputProvider, JUnitXmlResultOptions options, FailureType type, SerializableFailure failure) {
            super(outputProvider, options);
            this.failure = failure;
            this.type = type;
        }

        @Override
        public void write(SimpleXmlWriter writer) throws IOException {
            writer.startElement(this.type.elementName).attribute("message", this.failure.getMessage()).attribute("type", this.failure.getExceptionType());
            if (this.type.useStacktraceElementAndNestedOutput) {
                writer.startElement("stackTrace").characters((CharSequence)this.failure.getStackTrace()).endElement();
                this.writeOutput(writer);
                writer.endElement();
            } else {
                writer.characters((CharSequence)this.failure.getStackTrace());
                writer.endElement();
                this.writeOutput(writer);
            }
        }
    }
}

