/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.cache;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.LighterAST;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTTokenNode;
import org.jetbrains.kotlin.com.intellij.lang.java.lexer.JavaDocLexer;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.JavaDocTokenType;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.impl.cache.ModifierFlags;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiClassStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiFieldStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LightTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.CharTable;

public final class RecordUtil {
    private RecordUtil() {
    }

    public static boolean isDeprecatedByAnnotation(@NotNull LighterAST tree, @NotNull LighterASTNode modList) {
        if (tree == null) {
            RecordUtil.$$$reportNull$$$0(0);
        }
        if (modList == null) {
            RecordUtil.$$$reportNull$$$0(1);
        }
        for (LighterASTNode child : tree.getChildren(modList)) {
            String name2;
            LighterASTNode id;
            LighterASTNode ref;
            if (child.getTokenType() != JavaElementType.ANNOTATION || (ref = LightTreeUtil.firstChildOfType(tree, child, JavaElementType.JAVA_CODE_REFERENCE)) == null || (id = LightTreeUtil.firstChildOfType(tree, ref, JavaTokenType.IDENTIFIER)) == null || !"Deprecated".equals(name2 = RecordUtil.intern(tree.getCharTable(), id))) continue;
            return true;
        }
        return false;
    }

    public static boolean isDeprecatedByDocComment(@NotNull LighterAST tree, @NotNull LighterASTNode comment) {
        String text;
        if (tree == null) {
            RecordUtil.$$$reportNull$$$0(2);
        }
        if (comment == null) {
            RecordUtil.$$$reportNull$$$0(3);
        }
        if ((text = LightTreeUtil.toFilteredString(tree, comment, null)).contains("@deprecated")) {
            IElementType token;
            JavaDocLexer lexer = new JavaDocLexer(LanguageLevel.HIGHEST);
            lexer.start(text);
            while ((token = lexer.getTokenType()) != null) {
                if (token == JavaDocTokenType.DOC_TAG_NAME && "@deprecated".equals(lexer.getTokenText())) {
                    return true;
                }
                lexer.advance();
            }
        }
        return false;
    }

    public static int packModifierList(@NotNull LighterAST tree, @NotNull LighterASTNode modList) {
        if (tree == null) {
            RecordUtil.$$$reportNull$$$0(4);
        }
        if (modList == null) {
            RecordUtil.$$$reportNull$$$0(5);
        }
        int packed = 0;
        for (LighterASTNode child : tree.getChildren(modList)) {
            packed |= ModifierFlags.KEYWORD_TO_MODIFIER_FLAG_MAP.getInt(child.getTokenType());
        }
        return packed;
    }

    @NotNull
    public static String intern(@NotNull CharTable table, @NotNull LighterASTNode node) {
        if (table == null) {
            RecordUtil.$$$reportNull$$$0(6);
        }
        if (node == null) {
            RecordUtil.$$$reportNull$$$0(7);
        }
        assert (node instanceof LighterASTTokenNode) : node;
        String string2 = table.intern(((LighterASTTokenNode)node).getText()).toString();
        if (string2 == null) {
            RecordUtil.$$$reportNull$$$0(8);
        }
        return string2;
    }

    public static boolean isStaticNonPrivateMember(@NotNull StubElement<?> stub) {
        PsiModifierListStub type2;
        if (stub == null) {
            RecordUtil.$$$reportNull$$$0(9);
        }
        if ((type2 = stub.findChildStubByType(JavaStubElementTypes.MODIFIER_LIST)) == null) {
            return false;
        }
        int mask = type2.getModifiersMask();
        if (ModifierFlags.hasModifierProperty("private", mask)) {
            return false;
        }
        if (ModifierFlags.hasModifierProperty("static", mask)) {
            return true;
        }
        return stub instanceof PsiFieldStub && stub.getStubType() == JavaElementType.ENUM_CONSTANT || stub.getParentStub() instanceof PsiClassStub && ((PsiClassStub)stub.getParentStub()).isInterface();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modList";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/cache/RecordUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/cache/RecordUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "intern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isDeprecatedByAnnotation";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isDeprecatedByDocComment";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "packModifierList";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "intern";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isStaticNonPrivateMember";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

