/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import org.gradle.api.internal.artifacts.ivyservice.TypedResolveException;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.resolution.failure.ReportableAsProblem;
import org.gradle.internal.exceptions.MultiCauseException;

public interface ResolutionHost {
    public DisplayName displayName();

    default public String getDisplayName() {
        return this.displayName().getDisplayName();
    }

    default public DisplayName displayName(String type) {
        return Describables.of((Object)this.displayName(), (Object)type);
    }

    public InternalProblems getProblems();

    default public void rethrowFailuresAndReportProblems(String resolutionType, Collection<Throwable> failures) {
        this.reportProblems(failures);
        this.consolidateFailures(resolutionType, failures).ifPresent(e -> {
            throw e;
        });
    }

    public Optional<TypedResolveException> consolidateFailures(String var1, Collection<Throwable> var2);

    default public void reportProblems(Throwable failure) {
        this.reportProblems(Collections.singleton(failure));
    }

    default public void reportProblems(Collection<Throwable> failures) {
        HashSet<Throwable> seen = new HashSet<Throwable>(failures.size() * 2);
        LinkedList<Throwable> exceptionQueue = new LinkedList<Throwable>(failures);
        while (!exceptionQueue.isEmpty()) {
            Throwable current = (Throwable)exceptionQueue.poll();
            if (!seen.add(current)) continue;
            if (current instanceof ReportableAsProblem) {
                ((ReportableAsProblem)((Object)current)).reportAsProblem(this.getProblems());
            }
            if (current instanceof MultiCauseException) {
                exceptionQueue.addAll(((MultiCauseException)current).getCauses());
                continue;
            }
            if (current.getCause() == null) continue;
            exceptionQueue.add(current.getCause());
        }
    }
}

