/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.wrapper;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Incubating;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.file.FileLookup;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.api.tasks.options.OptionValues;
import org.gradle.api.tasks.wrapper.GradleVersionResolver;
import org.gradle.api.tasks.wrapper.WrapperVersionsResources;
import org.gradle.api.tasks.wrapper.internal.DefaultWrapperVersionsResources;
import org.gradle.api.tasks.wrapper.internal.WrapperDefaults;
import org.gradle.api.tasks.wrapper.internal.WrapperGenerator;
import org.gradle.internal.instrumentation.api.annotations.ToBeReplacedByLazyProperty;
import org.gradle.util.GradleVersion;
import org.gradle.util.internal.GUtil;
import org.gradle.util.internal.WrapperDistributionUrlConverter;
import org.gradle.work.DisableCachingByDefault;
import org.gradle.wrapper.Download;
import org.gradle.wrapper.Logger;

@DisableCachingByDefault(because="Updating the wrapper is not worth caching")
public abstract class Wrapper
extends DefaultTask {
    public static final String DEFAULT_DISTRIBUTION_PARENT_NAME = "wrapper/dists";
    private Object scriptFile = "gradlew";
    private Object jarFile = "gradle/wrapper/gradle-wrapper.jar";
    private String distributionPath = "wrapper/dists";
    private PathBase distributionBase = WrapperDefaults.DISTRIBUTION_BASE;
    private String distributionUrl;
    private String distributionSha256Sum;
    private final GradleVersionResolver gradleVersionResolver = new GradleVersionResolver();
    private DistributionType distributionType = WrapperDefaults.DISTRIBUTION_TYPE;
    private String archivePath = "wrapper/dists";
    private PathBase archiveBase = WrapperDefaults.ARCHIVE_BASE;
    private final Property<Integer> networkTimeout = this.getProject().getObjects().property(Integer.class);
    private boolean distributionUrlConfigured = false;
    private final boolean isOffline = this.getProject().getGradle().getStartParameter().isOffline();
    private static final String DISTRIBUTION_URL_EXCEPTION_MESSAGE = "Test of distribution url %s failed. Please check the values set with --gradle-distribution-url and --gradle-version.";

    public Wrapper() {
        this.getValidateDistributionUrl().convention((Object)true);
    }

    @TaskAction
    void generate() {
        File jarFileDestination = this.getJarFile();
        File unixScript = this.getScriptFile();
        FileResolver resolver = this.getFileLookup().getFileResolver(unixScript.getParentFile());
        String jarFileRelativePath = resolver.resolveAsRelativePath((Object)jarFileDestination);
        File propertiesFile = this.getPropertiesFile();
        Properties existingProperties = propertiesFile.exists() ? GUtil.loadProperties((File)propertiesFile) : null;
        this.checkProperties(existingProperties);
        this.validateDistributionUrl(propertiesFile.getParentFile());
        WrapperGenerator.generate(this.archiveBase, this.archivePath, this.distributionBase, this.distributionPath, this.getDistributionSha256Sum(existingProperties), propertiesFile, jarFileDestination, jarFileRelativePath, unixScript, this.getBatchScript(), this.getDistributionUrl(), (Boolean)this.getValidateDistributionUrl().get(), (Integer)this.networkTimeout.getOrNull());
    }

    private void checkProperties(Properties existingProperties) {
        String checksumProperty;
        String string = checksumProperty = existingProperties != null ? existingProperties.getProperty("distributionSha256Sum", null) : null;
        if (!this.isCurrentVersion() && this.distributionSha256Sum == null && checksumProperty != null) {
            throw new GradleException("gradle-wrapper.properties contains distributionSha256Sum property, but the wrapper configuration does not have one. Specify one in the wrapper task configuration or with the --gradle-distribution-sha256-sum task option");
        }
    }

    private void validateDistributionUrl(File uriRoot) {
        if (this.distributionUrlConfigured && ((Boolean)this.getValidateDistributionUrl().get()).booleanValue()) {
            String url = this.getDistributionUrl();
            URI uri = Wrapper.getDistributionUri(uriRoot, url);
            if (uri.getScheme().equals("file")) {
                if (!Files.exists(Paths.get(uri).toAbsolutePath(), new LinkOption[0])) {
                    throw new UncheckedIOException(String.format(DISTRIBUTION_URL_EXCEPTION_MESSAGE, url));
                }
            } else if (uri.getScheme().startsWith("http") && !this.isOffline) {
                try {
                    new Download(new Logger(true), "gradlew", "0").sendHeadRequest(uri);
                }
                catch (Exception e) {
                    throw new UncheckedIOException(String.format(DISTRIBUTION_URL_EXCEPTION_MESSAGE, url), (Throwable)e);
                }
            }
        }
    }

    private static URI getDistributionUri(File uriRoot, String url) {
        try {
            return WrapperDistributionUrlConverter.convertDistributionUrl((String)url, (File)uriRoot);
        }
        catch (URISyntaxException e) {
            throw new GradleException("Distribution URL String cannot be parsed: " + url, (Throwable)e);
        }
    }

    private String getDistributionSha256Sum(Properties existingProperties) {
        if (this.distributionSha256Sum != null) {
            return this.distributionSha256Sum;
        }
        if (this.isCurrentVersion() && existingProperties != null) {
            return existingProperties.getProperty("distributionSha256Sum", null);
        }
        return null;
    }

    private boolean isCurrentVersion() {
        return GradleVersion.current().equals(this.gradleVersionResolver.getGradleVersion());
    }

    @OutputFile
    @ToBeReplacedByLazyProperty
    public File getScriptFile() {
        return ((FileOperations)this.getServices().get(FileOperations.class)).file(this.scriptFile);
    }

    public void setScriptFile(File scriptFile) {
        this.scriptFile = scriptFile;
    }

    public void setScriptFile(Object scriptFile) {
        this.scriptFile = scriptFile;
    }

    @OutputFile
    @ToBeReplacedByLazyProperty
    public File getBatchScript() {
        return WrapperGenerator.getBatchScript(this.getScriptFile());
    }

    @OutputFile
    @ToBeReplacedByLazyProperty
    public File getJarFile() {
        return ((FileOperations)this.getServices().get(FileOperations.class)).file(this.jarFile);
    }

    public void setJarFile(File jarFile) {
        this.jarFile = jarFile;
    }

    public void setJarFile(Object jarFile) {
        this.jarFile = jarFile;
    }

    @OutputFile
    @ToBeReplacedByLazyProperty
    public File getPropertiesFile() {
        return WrapperGenerator.getPropertiesFile(this.getJarFile());
    }

    @Input
    @ToBeReplacedByLazyProperty
    public String getDistributionPath() {
        return this.distributionPath;
    }

    public void setDistributionPath(String distributionPath) {
        this.distributionPath = distributionPath;
    }

    @Incubating
    public void setWrapperVersionsResources(WrapperVersionsResources wrapperVersionsResources) {
        DefaultWrapperVersionsResources defaultWrapperVersionsResources = (DefaultWrapperVersionsResources)wrapperVersionsResources;
        this.gradleVersionResolver.setTextResources(defaultWrapperVersionsResources.getLatest(), defaultWrapperVersionsResources.getReleaseCandidate(), defaultWrapperVersionsResources.getNightly(), defaultWrapperVersionsResources.getReleaseNightly());
    }

    @Input
    @ToBeReplacedByLazyProperty
    public String getGradleVersion() {
        return this.gradleVersionResolver.getGradleVersion().getVersion();
    }

    @Option(option="gradle-version", description="The version of the Gradle distribution required by the wrapper. The following labels are allowed: latest, release-candidate, nightly, and release-nightly.")
    public void setGradleVersion(String gradleVersion) {
        this.distributionUrlConfigured = true;
        this.gradleVersionResolver.setGradleVersionString(gradleVersion);
    }

    @Input
    @ToBeReplacedByLazyProperty
    public DistributionType getDistributionType() {
        return this.distributionType;
    }

    @Option(option="distribution-type", description="The type of the Gradle distribution to be used by the wrapper.")
    public void setDistributionType(DistributionType distributionType) {
        this.distributionType = distributionType;
    }

    @OptionValues(value={"distribution-type"})
    @ToBeReplacedByLazyProperty(comment="Not supported yet", issue="https://github.com/gradle/gradle/issues/29341")
    public List<DistributionType> getAvailableDistributionTypes() {
        return Arrays.asList(DistributionType.values());
    }

    @Input
    @ToBeReplacedByLazyProperty
    public String getDistributionUrl() {
        if (this.distributionUrl != null) {
            return this.distributionUrl;
        }
        return WrapperGenerator.getDistributionUrl(this.gradleVersionResolver.getGradleVersion(), this.distributionType);
    }

    @Option(option="gradle-distribution-url", description="The URL to download the Gradle distribution from.")
    public void setDistributionUrl(String url) {
        this.distributionUrlConfigured = true;
        this.distributionUrl = url;
    }

    @Nullable
    @Optional
    @Input
    @ToBeReplacedByLazyProperty
    public String getDistributionSha256Sum() {
        return this.distributionSha256Sum;
    }

    @Option(option="gradle-distribution-sha256-sum", description="The SHA-256 hash sum of the gradle distribution.")
    public void setDistributionSha256Sum(@Nullable String distributionSha256Sum) {
        this.distributionSha256Sum = distributionSha256Sum;
    }

    @Input
    @ToBeReplacedByLazyProperty
    public PathBase getDistributionBase() {
        return this.distributionBase;
    }

    public void setDistributionBase(PathBase distributionBase) {
        this.distributionBase = distributionBase;
    }

    @Input
    @ToBeReplacedByLazyProperty
    public String getArchivePath() {
        return this.archivePath;
    }

    public void setArchivePath(String archivePath) {
        this.archivePath = archivePath;
    }

    @Input
    @ToBeReplacedByLazyProperty
    public PathBase getArchiveBase() {
        return this.archiveBase;
    }

    public void setArchiveBase(PathBase archiveBase) {
        this.archiveBase = archiveBase;
    }

    @Input
    @Incubating
    @Optional
    @Option(option="network-timeout", description="Timeout in ms to use when the wrapper is performing network operations.")
    public Property<Integer> getNetworkTimeout() {
        return this.networkTimeout;
    }

    @Incubating
    @Input
    @Option(option="validate-url", description="Sets task to validate the configured distribution url.")
    public abstract Property<Boolean> getValidateDistributionUrl();

    @Inject
    protected FileLookup getFileLookup() {
        throw new UnsupportedOperationException();
    }

    public static enum PathBase {
        PROJECT,
        GRADLE_USER_HOME;

    }

    public static enum DistributionType {
        BIN,
        ALL;

    }
}

