/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildoption;

import java.util.Map;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.internal.buildoption.AbstractBuildOption;
import org.gradle.internal.buildoption.BooleanCommandLineOptionConfiguration;
import org.gradle.internal.buildoption.CommandLineOptionConfiguration;
import org.gradle.internal.buildoption.Origin;

public abstract class BooleanBuildOption<T>
extends AbstractBuildOption<T, BooleanCommandLineOptionConfiguration> {
    public BooleanBuildOption(String property) {
        this(property, (String)null, new BooleanCommandLineOptionConfiguration[0]);
    }

    public BooleanBuildOption(String property, BooleanCommandLineOptionConfiguration ... commandLineOptionConfigurations) {
        this(property, (String)null, commandLineOptionConfigurations);
    }

    public BooleanBuildOption(String property, String deprecatedProperty, BooleanCommandLineOptionConfiguration ... commandLineOptionConfigurations) {
        super(property, deprecatedProperty, (CommandLineOptionConfiguration[])commandLineOptionConfigurations);
    }

    @Override
    public void applyFromProperty(Map<String, String> properties, T settings) {
        AbstractBuildOption.OptionValue<String> propertyValue = this.getFromProperties(properties);
        String value = propertyValue.getValue();
        if (value != null) {
            this.applyTo(this.isTrue(value), settings, propertyValue.getOrigin());
        }
    }

    @Override
    public void configure(CommandLineParser parser) {
        for (BooleanCommandLineOptionConfiguration config : this.commandLineOptionConfigurations) {
            this.configureCommandLineOption(parser, new String[]{config.getLongOption()}, config.getDescription(), config.isDeprecated(), config.isIncubating());
            String disabledOption = this.getDisabledCommandLineOption(config);
            this.configureCommandLineOption(parser, new String[]{disabledOption}, config.getDisabledDescription(), config.isDeprecated(), config.isIncubating());
            parser.allowOneOf(new String[]{config.getLongOption(), disabledOption});
        }
    }

    @Override
    public void applyFromCommandLine(ParsedCommandLine options, T settings) {
        for (BooleanCommandLineOptionConfiguration config : this.commandLineOptionConfigurations) {
            if (options.hasOption(config.getLongOption())) {
                this.applyTo(true, settings, Origin.forCommandLine(config.getLongOption()));
            }
            if (!options.hasOption(this.getDisabledCommandLineOption(config))) continue;
            this.applyTo(false, settings, Origin.forCommandLine(this.getDisabledCommandLineOption(config)));
        }
    }

    private String getDisabledCommandLineOption(BooleanCommandLineOptionConfiguration config) {
        return "no-" + config.getLongOption();
    }

    public abstract void applyTo(boolean var1, T var2, Origin var3);
}

