/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.processing;

import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileManager;
import org.gradle.api.internal.tasks.compile.incremental.processing.AnnotationProcessorResult;
import org.gradle.api.internal.tasks.compile.incremental.processing.IncrementalAnnotationProcessorType;
import org.gradle.api.internal.tasks.compile.processing.AggregatingProcessingStrategy;
import org.gradle.api.internal.tasks.compile.processing.IncrementalProcessingStrategy;
import org.gradle.api.internal.tasks.compile.processing.IsolatingProcessingStrategy;
import org.gradle.api.internal.tasks.compile.processing.NonIncrementalProcessingStrategy;

public class DynamicProcessingStrategy
extends IncrementalProcessingStrategy {
    private IncrementalProcessingStrategy delegate;

    DynamicProcessingStrategy(String processorName, AnnotationProcessorResult result) {
        super(result);
        this.delegate = new NonIncrementalProcessingStrategy(processorName, result);
    }

    public void updateFromOptions(Set<String> supportedOptions) {
        if (supportedOptions.contains(IncrementalAnnotationProcessorType.ISOLATING.getProcessorOption())) {
            this.delegate = new IsolatingProcessingStrategy(this.result);
        } else if (supportedOptions.contains(IncrementalAnnotationProcessorType.AGGREGATING.getProcessorOption())) {
            this.delegate = new AggregatingProcessingStrategy(this.result);
        }
    }

    @Override
    public void recordProcessingInputs(Set<String> supportedAnnotationTypes, Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.delegate.recordProcessingInputs(supportedAnnotationTypes, annotations, roundEnv);
    }

    @Override
    public void recordGeneratedType(CharSequence name, Element[] originatingElements) {
        this.delegate.recordGeneratedType(name, originatingElements);
    }

    @Override
    public void recordGeneratedResource(JavaFileManager.Location location, CharSequence pkg, CharSequence relativeName, Element[] originatingElements) {
        this.delegate.recordGeneratedResource(location, pkg, relativeName, originatingElements);
    }
}

