/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jvm.inspection;

import java.io.File;
import java.nio.file.NoSuchFileException;
import org.gradle.api.GradleException;
import org.gradle.api.internal.jvm.JavaVersionParser;
import org.gradle.internal.jvm.JavaInfo;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.internal.jvm.inspection.JvmMetadataDetector;
import org.gradle.internal.jvm.inspection.JvmVersionDetector;
import org.gradle.jvm.toolchain.internal.InstallationLocation;
import org.gradle.process.internal.ExecException;

public class DefaultJvmVersionDetector
implements JvmVersionDetector {
    private final JvmMetadataDetector detector;

    public DefaultJvmVersionDetector(JvmMetadataDetector detector) {
        this.detector = detector;
    }

    @Override
    public int getJavaVersionMajor(JavaInfo jvm) {
        return this.getVersionFromJavaHome(jvm.getJavaHome());
    }

    @Override
    public int getJavaVersionMajor(String javaCommand) {
        File executable = new File(javaCommand);
        File parentFolder = executable.getParentFile();
        if (parentFolder == null || !parentFolder.exists()) {
            NoSuchFileException cause = new NoSuchFileException(javaCommand);
            throw new ExecException("A problem occurred starting process 'command '" + javaCommand + "''", (Throwable)cause);
        }
        return this.getVersionFromJavaHome(parentFolder.getParentFile());
    }

    private int getVersionFromJavaHome(File javaHome) {
        JvmInstallationMetadata metadata = this.validate(this.detector.getMetadata(InstallationLocation.autoDetected(javaHome, "specific path")));
        return JavaVersionParser.parseMajorVersion((String)metadata.getJavaVersion());
    }

    private JvmInstallationMetadata validate(JvmInstallationMetadata metadata) {
        if (metadata.isValidInstallation()) {
            return metadata;
        }
        throw new GradleException("Unable to determine version for JDK located at " + metadata.getJavaHome() + ". Reason: " + metadata.getErrorMessage(), metadata.getErrorCause());
    }
}

