/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.jvm.toolchain.internal.InstallationLocation;
import org.gradle.jvm.toolchain.internal.InstallationSupplier;
import org.gradle.jvm.toolchain.internal.ToolchainConfiguration;

public class EnvironmentVariableListInstallationSupplier
implements InstallationSupplier {
    public static final String JAVA_INSTALLATIONS_FROM_ENV_PROPERTY = "org.gradle.java.installations.fromEnv";
    private final ToolchainConfiguration buildOptions;
    private final FileResolver fileResolver;
    private final Map<String, String> environment;

    @Inject
    public EnvironmentVariableListInstallationSupplier(ToolchainConfiguration buildOptions, FileResolver fileResolver, Map<String, String> environment) {
        this.buildOptions = buildOptions;
        this.fileResolver = fileResolver;
        this.environment = environment;
    }

    @Override
    public String getSourceName() {
        return "environment variables from gradle property 'org.gradle.java.installations.fromEnv'";
    }

    @Override
    public Set<InstallationLocation> get() {
        Collection<String> possibleInstallations = this.buildOptions.getJavaInstallationsFromEnvironment();
        return possibleInstallations.stream().map(this::resolveEnvironmentVariable).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    private Optional<InstallationLocation> resolveEnvironmentVariable(String environmentVariable) {
        String path;
        String value = this.environmentVariableValue(environmentVariable);
        if (value != null && !(path = value.trim()).isEmpty()) {
            return Optional.of(InstallationLocation.userDefined(this.fileResolver.resolve((Object)path), "environment variable '" + environmentVariable + "'"));
        }
        return Optional.empty();
    }

    @Nullable
    private String environmentVariableValue(String environmentVariable) {
        return this.environment.get(environmentVariable.trim());
    }
}

