/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import com.google.common.collect.ImmutableListMultimap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.CaseSensitivity;
import org.gradle.internal.snapshot.ChildMap;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemNode;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.MetadataSnapshot;
import org.gradle.internal.snapshot.MissingFileSnapshot;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.gradle.internal.snapshot.RelativePathTracker;
import org.gradle.internal.snapshot.SnapshotVisitResult;
import org.gradle.internal.snapshot.VfsRelativePath;

public class SnapshotUtil {
    public static Map<String, FileSystemLocationSnapshot> indexByAbsolutePath(FileSystemSnapshot snapshot) {
        HashMap<String, FileSystemLocationSnapshot> index = new HashMap<String, FileSystemLocationSnapshot>();
        snapshot.accept(entrySnapshot -> {
            index.put(entrySnapshot.getAbsolutePath(), entrySnapshot);
            return SnapshotVisitResult.CONTINUE;
        });
        return index;
    }

    public static Map<String, FileSystemLocationSnapshot> indexByRelativePath(FileSystemSnapshot snapshot) {
        HashMap<String, FileSystemLocationSnapshot> index = new HashMap<String, FileSystemLocationSnapshot>();
        snapshot.accept(new RelativePathTracker(), (entrySnapshot, relativePath) -> {
            index.put(relativePath.toRelativePath(), entrySnapshot);
            return SnapshotVisitResult.CONTINUE;
        });
        return index;
    }

    public static Map<String, FileSystemLocationSnapshot> rootIndex(FileSystemSnapshot snapshot) {
        HashMap<String, FileSystemLocationSnapshot> index = new HashMap<String, FileSystemLocationSnapshot>();
        snapshot.accept(entrySnapshot -> {
            index.put(entrySnapshot.getAbsolutePath(), entrySnapshot);
            return SnapshotVisitResult.SKIP_SUBTREE;
        });
        return index;
    }

    public static <T extends FileSystemNode> Optional<MetadataSnapshot> getMetadataFromChildren(ChildMap<T> children, VfsRelativePath targetPath, final CaseSensitivity caseSensitivity, final Supplier<Optional<MetadataSnapshot>> noChildFoundResult) {
        return (Optional)children.withNode(targetPath, caseSensitivity, new ChildMap.NodeHandler<T, Optional<MetadataSnapshot>>(){

            @Override
            public Optional<MetadataSnapshot> handleAsDescendantOfChild(VfsRelativePath pathInChild, T child) {
                return child.getSnapshot(pathInChild, caseSensitivity);
            }

            @Override
            public Optional<MetadataSnapshot> handleAsAncestorOfChild(String childPath, T child) {
                return (Optional)noChildFoundResult.get();
            }

            @Override
            public Optional<MetadataSnapshot> handleExactMatchWithChild(T child) {
                return child.getSnapshot();
            }

            @Override
            public Optional<MetadataSnapshot> handleUnrelatedToAnyChild() {
                return (Optional)noChildFoundResult.get();
            }
        });
    }

    public static <T extends FileSystemNode> Optional<FileSystemNode> getChild(ChildMap<T> children, VfsRelativePath targetPath, final CaseSensitivity caseSensitivity) {
        return (Optional)children.withNode(targetPath, caseSensitivity, new ChildMap.NodeHandler<T, Optional<FileSystemNode>>(){

            @Override
            public Optional<FileSystemNode> handleAsDescendantOfChild(VfsRelativePath pathInChild, T child) {
                return child.getNode(pathInChild, caseSensitivity);
            }

            @Override
            public Optional<FileSystemNode> handleAsAncestorOfChild(String childPath, T child) {
                return Optional.of(child);
            }

            @Override
            public Optional<FileSystemNode> handleExactMatchWithChild(T child) {
                return Optional.of(child);
            }

            @Override
            public Optional<FileSystemNode> handleUnrelatedToAnyChild() {
                return Optional.empty();
            }
        });
    }

    public static ImmutableListMultimap<String, HashCode> getRootHashes(FileSystemSnapshot roots) {
        if (roots == FileSystemSnapshot.EMPTY) {
            return ImmutableListMultimap.of();
        }
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        roots.accept(snapshot -> {
            builder.put((Object)snapshot.getAbsolutePath(), (Object)snapshot.getHash());
            return SnapshotVisitResult.SKIP_SUBTREE;
        });
        return builder.build();
    }

    public static long getLength(FileSystemLocationSnapshot snapshot) {
        return snapshot.accept(new FileSystemLocationSnapshot.FileSystemLocationSnapshotTransformer<Long>(){

            @Override
            public Long visitDirectory(DirectorySnapshot directorySnapshot) {
                return 0L;
            }

            @Override
            public Long visitRegularFile(RegularFileSnapshot fileSnapshot) {
                return fileSnapshot.getMetadata().getLength();
            }

            @Override
            public Long visitMissing(MissingFileSnapshot missingSnapshot) {
                return 0L;
            }
        });
    }
}

