/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.security.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.security.internal.Fingerprint;
import org.gradle.security.internal.KeyringStripper;

public class SecuritySupport {
    private static final Logger LOGGER = Logging.getLogger(SecuritySupport.class);
    private static final int BUFFER = 4096;
    public static final String KEYS_FILE_EXT = ".keys";

    public static boolean verify(File file, PGPSignature signature, PGPPublicKey publicKey) throws PGPException {
        signature.init(SecuritySupport.createContentVerifier(), publicKey);
        byte[] buffer = new byte[4096];
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            int len;
            while ((len = ((InputStream)in).read(buffer)) >= 0) {
                signature.update(buffer, 0, len);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        return signature.verify();
    }

    private static PGPContentVerifierBuilderProvider createContentVerifier() {
        return new BcPGPContentVerifierBuilderProvider();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static PGPSignatureList readSignatures(File file) {
        try (BufferedInputStream stream = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
            PGPSignatureList pGPSignatureList;
            block13: {
                InputStream decoderStream = PGPUtil.getDecoderStream((InputStream)stream);
                try {
                    pGPSignatureList = SecuritySupport.readSignatureList(decoderStream, file.toString());
                    if (decoderStream == null) break block13;
                }
                catch (Throwable throwable) {
                    if (decoderStream != null) {
                        try {
                            decoderStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                decoderStream.close();
            }
            return pGPSignatureList;
        }
        catch (IOException | PGPException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Nullable
    private static PGPSignatureList readSignatureList(InputStream decoderStream, String locationHint) throws IOException, PGPException {
        PGPObjectFactory objectFactory = new PGPObjectFactory(decoderStream, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        Object nextObject = objectFactory.nextObject();
        if (nextObject instanceof PGPSignatureList) {
            return (PGPSignatureList)nextObject;
        }
        if (nextObject instanceof PGPCompressedData) {
            return SecuritySupport.readSignatureList(((PGPCompressedData)nextObject).getDataStream(), locationHint);
        }
        LOGGER.warn("Expected a signature list in {}, but got {}. Skipping this signature.", (Object)locationHint, nextObject == null ? "invalid file" : nextObject.getClass());
        return null;
    }

    public static String toLongIdHexString(long key) {
        return String.format("%016X", key).trim();
    }

    public static String toHexString(byte[] fingerprint) {
        return Fingerprint.wrap(fingerprint).toString();
    }

    public static List<PGPPublicKeyRing> loadKeyRingFile(File keyringFile) throws IOException {
        ArrayList<PGPPublicKeyRing> existingRings = new ArrayList<PGPPublicKeyRing>();
        try (InputStream ins = PGPUtil.getDecoderStream((InputStream)SecuritySupport.createInputStreamFor(keyringFile));){
            JcaPGPObjectFactory objectFactory = new JcaPGPObjectFactory(ins);
            JcaKeyFingerprintCalculator fingerprintCalculator = new JcaKeyFingerprintCalculator();
            try {
                for (Object o : objectFactory) {
                    if (!(o instanceof PGPPublicKeyRing)) continue;
                    PGPPublicKeyRing strippedKeyRing = KeyringStripper.strip((PGPPublicKeyRing)o, (KeyFingerPrintCalculator)fingerprintCalculator);
                    existingRings.add(strippedKeyRing);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Error while reading the keyring file. {} keys read: {}", (Object)existingRings.size(), (Object)e.getMessage());
            }
        }
        return existingRings;
    }

    private static InputStream createInputStreamFor(File keyringFile) throws IOException {
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(keyringFile));
        if (keyringFile.getName().endsWith(KEYS_FILE_EXT)) {
            return new ArmoredInputStream((InputStream)stream);
        }
        return stream;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.setProperty("crypto.policy", "unlimited");
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

