/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.ast;

import net.sourceforge.pmd.ast.JavaParser;
import net.sourceforge.pmd.ast.SimpleJavaNode;

public class AccessNode
extends SimpleJavaNode {
    public static final int PUBLIC = 1;
    public static final int PROTECTED = 2;
    public static final int PRIVATE = 4;
    public static final int ABSTRACT = 8;
    public static final int STATIC = 16;
    public static final int FINAL = 32;
    public static final int SYNCHRONIZED = 64;
    public static final int NATIVE = 128;
    public static final int TRANSIENT = 256;
    public static final int VOLATILE = 512;
    public static final int STRICTFP = 4096;
    private int modifiers;

    public AccessNode(int i) {
        super(i);
    }

    public AccessNode(JavaParser parser, int i) {
        super(parser, i);
    }

    public void setModifiers(int m) {
        this.modifiers = m;
    }

    public boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public boolean isProtected() {
        return (this.modifiers & 2) != 0;
    }

    public boolean isPrivate() {
        return (this.modifiers & 4) != 0;
    }

    public boolean isStatic() {
        return (this.modifiers & 0x10) != 0;
    }

    public boolean isAbstract() {
        return (this.modifiers & 8) != 0;
    }

    public boolean isFinal() {
        return (this.modifiers & 0x20) != 0;
    }

    public boolean isNative() {
        return (this.modifiers & 0x80) != 0;
    }

    public boolean isStrictfp() {
        return (this.modifiers & 0x1000) != 0;
    }

    public boolean isSynchronized() {
        return (this.modifiers & 0x40) != 0;
    }

    public boolean isTransient() {
        return (this.modifiers & 0x100) != 0;
    }

    public boolean isVolatile() {
        return (this.modifiers & 0x200) != 0;
    }

    public void setPublic() {
        this.modifiers |= 1;
    }

    public void setPrivate() {
        this.modifiers |= 4;
    }

    public void setProtected() {
        this.modifiers |= 2;
    }

    public void setSynchronized() {
        this.modifiers |= 0x40;
    }

    public void setVolatile() {
        this.modifiers |= 0x200;
    }

    public void setAbstract() {
        this.modifiers |= 8;
    }

    public void setStatic() {
        this.modifiers |= 0x10;
    }

    public void setTransient() {
        this.modifiers |= 0x100;
    }

    public void setFinal() {
        this.modifiers |= 0x20;
    }

    public void setNative() {
        this.modifiers |= 0x80;
    }

    public void setStrictfp() {
        this.modifiers |= 0x1000;
    }

    static int removeModifier(int modifiers, int mod) {
        return modifiers & ~mod;
    }

    public boolean isPackagePrivate() {
        return !this.isPrivate() && !this.isPublic() && !this.isProtected();
    }

    public String collectDumpedModifiers(String prefix) {
        String out = this.toString(prefix) + ":";
        if (this.isPackagePrivate()) {
            out = out + "(package private)";
        }
        if (this.isPrivate()) {
            out = out + "(private)";
        }
        if (this.isPublic()) {
            out = out + "(public)";
        }
        if (this.isProtected()) {
            out = out + "(protected)";
        }
        if (this.isAbstract()) {
            out = out + "(abstract)";
        }
        if (this.isStatic()) {
            out = out + "(static)";
        }
        if (this.isFinal()) {
            out = out + "(final)";
        }
        if (this.isSynchronized()) {
            out = out + "(synchronized)";
        }
        if (this.isNative()) {
            out = out + "(native)";
        }
        if (this.isStrictfp()) {
            out = out + "(strict)";
        }
        if (this.isTransient()) {
            out = out + "(transient)";
        }
        return out;
    }
}

