/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import oracle.net.jndi.JndiAttrs;

public class ClientProfile
extends Properties {
    private static final String profile_name = "ora-net-profile";
    private static final String shared_profile_name = "ora-shared-profile";

    public ClientProfile() {
    }

    public ClientProfile(Properties properties) {
        if (((Hashtable)properties).containsKey("oracle.net.profile")) {
            ((Hashtable)this).put("oracle.net.profile", properties.getProperty("oracle.net.profile"));
        }
        ((Hashtable)this).put("oracle.net.authentication_services", properties.getProperty("oracle.net.authentication_services", "()"));
        ((Hashtable)this).put("oracle.net.encryption_client", properties.getProperty("oracle.net.encryption_client", "ACCEPTED"));
        ((Hashtable)this).put("oracle.net.encryption_types_client", properties.getProperty("oracle.net.encryption_types_client", "()"));
        ((Hashtable)this).put("oracle.net.crypto_checksum_client", properties.getProperty("oracle.net.crypto_checksum_client", "ACCEPTED"));
        ((Hashtable)this).put("oracle.net.crypto_checksum_types_client", properties.getProperty("oracle.net.crypto_checksum_types_client", "()"));
        ((Hashtable)this).put("oracle.net.crypto_seed", properties.getProperty("oracle.net.crypto_seed", ""));
    }

    public ClientProfile(Properties properties, JndiAttrs jndiAttrs) {
        this(properties);
        if (((Hashtable)properties).containsKey("oracle.net.profile")) {
            ((Hashtable)this).put("oracle.net.profile", properties.getProperty("oracle.net.profile"));
        }
        if (((Hashtable)properties).containsKey("java.naming.provider.url")) {
            ((Hashtable)this).put("java.naming.provider.url", properties.getProperty("java.naming.provider.url"));
        } else {
            ((Hashtable)this).put("java.naming.provider.url", "com.sun.jndi.ldap.LdapCtxFactory");
        }
        if (((Hashtable)properties).containsKey("java.naming.factory.initial")) {
            ((Hashtable)this).put("java.naming.factory.initial", properties.getProperty("java.naming.factory.initial"));
        }
    }

    public String[] getAuthenticationServices() {
        return this.getServices((String)((Hashtable)this).get("oracle.net.authentication_services"));
    }

    public String getDataIntegrityLevel() {
        return (String)((Hashtable)this).get("oracle.net.crypto_checksum_client");
    }

    public int getDataIntegrityLevelNum() {
        return this.translateAnoValue(this.getDataIntegrityLevel());
    }

    public String[] getDataIntegrityServices() {
        return this.getServices((String)((Hashtable)this).get("oracle.net.crypto_checksum_types_client"));
    }

    public String getEncryptionLevel() {
        return (String)((Hashtable)this).get("oracle.net.encryption_client");
    }

    public int getEncryptionLevelNum() {
        return this.translateAnoValue(this.getEncryptionLevel());
    }

    public String[] getEncryptionServices() {
        return this.getServices((String)((Hashtable)this).get("oracle.net.encryption_types_client"));
    }

    private String[] getServices(String string) {
        String string2 = this.removeParenths(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = stringTokenizer.nextToken().trim();
            ++n2;
        }
        return stringArray;
    }

    public void print() {
        System.out.println(" ----------------------------------------");
        System.out.println(" Displaying the content of ClientProfile ");
        System.out.println(" List:");
        this.list(System.out);
        Enumeration<?> enumeration = this.propertyNames();
        System.out.println("Enumeration has elements ? " + enumeration.hasMoreElements());
        int n = 0;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            System.out.println("Key " + n + " = " + string);
            System.out.println("Value = " + this.getProperty(string));
            ++n;
        }
        System.out.println(" ----------------------------------------");
    }

    private String removeParenths(String string) {
        int n = string.indexOf(40);
        int n2 = n == -1 ? 0 : n + 1;
        int n3 = string.lastIndexOf(41);
        int n4 = n3 == -1 ? string.length() : n3;
        String string2 = string.substring(n2, n4);
        return string2.trim();
    }

    private int translateAnoValue(String string) {
        int n = 0;
        if (string.equalsIgnoreCase("ACCEPTED")) {
            n = 0;
        } else if (string.equalsIgnoreCase("REQUESTED")) {
            n = 2;
        } else if (string.equalsIgnoreCase("REQUIRED")) {
            n = 3;
        }
        return n;
    }
}

