/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.core;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.core.CoreApplicationEnvironment;
import org.jetbrains.kotlin.com.intellij.core.CoreEncodingProjectManager;
import org.jetbrains.kotlin.com.intellij.core.CoreInjectedLanguageManager;
import org.jetbrains.kotlin.com.intellij.core.CoreProjectScopeBuilder;
import org.jetbrains.kotlin.com.intellij.core.CorePsiDocumentManager;
import org.jetbrains.kotlin.com.intellij.core.MockDocumentCommitProcessor;
import org.jetbrains.kotlin.com.intellij.lang.injection.InjectedLanguageManager;
import org.jetbrains.kotlin.com.intellij.mock.MockDumbService;
import org.jetbrains.kotlin.com.intellij.mock.MockDumbUtil;
import org.jetbrains.kotlin.com.intellij.mock.MockFileIndexFacade;
import org.jetbrains.kotlin.com.intellij.mock.MockProject;
import org.jetbrains.kotlin.com.intellij.mock.MockResolveScopeManager;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPointName;
import org.jetbrains.kotlin.com.intellij.openapi.project.DumbService;
import org.jetbrains.kotlin.com.intellij.openapi.project.DumbUtil;
import org.jetbrains.kotlin.com.intellij.openapi.roots.FileIndexFacade;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.psi.PsiDocumentManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiFileFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.SmartPointerManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.DocumentCommitProcessor;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiCachedValuesFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiFileFactoryImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiManagerImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiModificationTrackerImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.ResolveScopeManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.PsiDirectoryFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.PsiDirectoryFactoryImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.ResolveCache;
import org.jetbrains.kotlin.com.intellij.psi.search.ProjectScopeBuilder;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.kotlin.com.intellij.util.CachedValuesManagerImpl;
import org.jetbrains.kotlin.org.picocontainer.PicoContainer;

public class CoreProjectEnvironment {
    private final Disposable myParentDisposable;
    private final CoreApplicationEnvironment myEnvironment;
    protected final FileIndexFacade myFileIndexFacade;
    protected final PsiManagerImpl myPsiManager;
    protected final MockProject project;

    public CoreProjectEnvironment(@NotNull Disposable parentDisposable, @NotNull CoreApplicationEnvironment applicationEnvironment) {
        if (parentDisposable == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(0);
        }
        if (applicationEnvironment == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(1);
        }
        this.myParentDisposable = parentDisposable;
        this.myEnvironment = applicationEnvironment;
        this.project = this.createProject(this.myEnvironment.getApplication().getPicoContainer(), this.myParentDisposable);
        this.preregisterServices();
        this.myFileIndexFacade = this.createFileIndexFacade();
        PsiModificationTrackerImpl modificationTracker = new PsiModificationTrackerImpl(this.project);
        this.project.registerService(PsiModificationTracker.class, modificationTracker);
        this.project.registerService(FileIndexFacade.class, this.myFileIndexFacade);
        this.project.registerService(ResolveCache.class, new ResolveCache(this.project));
        this.myPsiManager = new PsiManagerImpl(this.project);
        this.project.registerService(PsiManager.class, this.myPsiManager);
        this.project.registerService(SmartPointerManager.class, SmartPointerManagerImpl.class);
        this.project.registerService(DocumentCommitProcessor.class, new MockDocumentCommitProcessor());
        this.project.registerService(PsiDocumentManager.class, new CorePsiDocumentManager(this.project));
        this.project.registerService(ResolveScopeManager.class, this.createResolveScopeManager(this.myPsiManager));
        this.project.registerService(PsiFileFactory.class, new PsiFileFactoryImpl(this.myPsiManager));
        this.project.registerService(CachedValuesManager.class, new CachedValuesManagerImpl(this.project, new PsiCachedValuesFactory(this.project)));
        this.project.registerService(PsiDirectoryFactory.class, new PsiDirectoryFactoryImpl(this.project));
        this.project.registerService(ProjectScopeBuilder.class, this.createProjectScopeBuilder());
        this.project.registerService(DumbService.class, new MockDumbService(this.project));
        this.project.registerService(DumbUtil.class, new MockDumbUtil());
        this.project.registerService(CoreEncodingProjectManager.class, CoreEncodingProjectManager.class);
        this.project.registerService(InjectedLanguageManager.class, new CoreInjectedLanguageManager());
    }

    @NotNull
    protected MockProject createProject(@NotNull PicoContainer parent2, @NotNull Disposable parentDisposable) {
        if (parent2 == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(2);
        }
        if (parentDisposable == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(3);
        }
        return new MockProject(parent2, parentDisposable);
    }

    @NotNull
    protected ProjectScopeBuilder createProjectScopeBuilder() {
        return new CoreProjectScopeBuilder(this.project, this.myFileIndexFacade);
    }

    protected void preregisterServices() {
    }

    @NotNull
    protected FileIndexFacade createFileIndexFacade() {
        return new MockFileIndexFacade(this.project);
    }

    @NotNull
    protected ResolveScopeManager createResolveScopeManager(@NotNull PsiManager psiManager) {
        if (psiManager == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(4);
        }
        return new MockResolveScopeManager(psiManager.getProject());
    }

    public <T> void addProjectExtension(@NotNull ExtensionPointName<T> name2, @NotNull T extension) {
        if (name2 == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(5);
        }
        if (extension == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(6);
        }
        name2.getPoint(this.project).registerExtension(extension, this.myParentDisposable);
    }

    public <T> void registerProjectComponent(@NotNull Class<T> interfaceClass, @NotNull T implementation2) {
        if (interfaceClass == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(7);
        }
        if (implementation2 == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(8);
        }
        CoreApplicationEnvironment.registerComponentInstance(this.project.getPicoContainer(), interfaceClass, implementation2);
        if (implementation2 instanceof Disposable) {
            Disposer.register(this.project, (Disposable)implementation2);
        }
    }

    @NotNull
    public Disposable getParentDisposable() {
        Disposable disposable = this.myParentDisposable;
        if (disposable == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(9);
        }
        return disposable;
    }

    @NotNull
    public CoreApplicationEnvironment getEnvironment() {
        CoreApplicationEnvironment coreApplicationEnvironment = this.myEnvironment;
        if (coreApplicationEnvironment == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(10);
        }
        return coreApplicationEnvironment;
    }

    @NotNull
    public MockProject getProject() {
        MockProject mockProject = this.project;
        if (mockProject == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(11);
        }
        return mockProject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationEnvironment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementation";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/core/CoreProjectEnvironment";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/core/CoreProjectEnvironment";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentDisposable";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironment";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createProject";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createResolveScopeManager";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addProjectExtension";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerProjectComponent";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

