/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util.io;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtilRt;

public final class NioFiles {
    public static final BasicFileAttributes BROKEN_SYMLINK = new BasicFileAttributes(){
        private final FileTime ZERO = FileTime.fromMillis(0L);

        @Override
        public FileTime lastModifiedTime() {
            return this.ZERO;
        }

        @Override
        public FileTime lastAccessTime() {
            return this.ZERO;
        }

        @Override
        public FileTime creationTime() {
            return this.ZERO;
        }

        @Override
        public boolean isRegularFile() {
            return false;
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        @Override
        public boolean isSymbolicLink() {
            return true;
        }

        @Override
        public boolean isOther() {
            return false;
        }

        @Override
        public long size() {
            return 0L;
        }

        @Override
        public Object fileKey() {
            return null;
        }
    };
    private static final Logger LOG = Logger.getInstance(NioFiles.class);
    private static final LinkOption[] NO_FOLLOW = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};

    private NioFiles() {
    }

    @NotNull
    public static String getFileName(@NotNull Path path) {
        Path name2;
        if (path == null) {
            NioFiles.$$$reportNull$$$0(1);
        }
        String string = ((name2 = path.getFileName()) != null ? name2 : path).toString();
        if (string == null) {
            NioFiles.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static Path createDirectories(@NotNull Path path) throws IOException {
        if (path == null) {
            NioFiles.$$$reportNull$$$0(3);
        }
        try {
            NioFiles.tryCreateDirectory(path);
        }
        catch (FileAlreadyExistsException e2) {
            throw e2;
        }
        catch (IOException e3) {
            Path parent2 = path.getParent();
            if (parent2 == null) {
                throw e3;
            }
            NioFiles.createDirectories(parent2);
            NioFiles.tryCreateDirectory(path);
        }
        Path path2 = path;
        if (path2 == null) {
            NioFiles.$$$reportNull$$$0(4);
        }
        return path2;
    }

    private static void tryCreateDirectory(Path path) throws IOException {
        block2: {
            try {
                Files.createDirectory(path, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException e2) {
                if (Files.isDirectory(path, new LinkOption[0])) break block2;
                throw e2;
            }
        }
    }

    public static boolean isWritable(@NotNull Path path) {
        if (path == null) {
            NioFiles.$$$reportNull$$$0(7);
        }
        try {
            return Files.isWritable(path);
        }
        catch (SecurityException e2) {
            return false;
        }
    }

    public static void setExecutable(@NotNull Path file) throws IOException {
        Set<PosixFilePermission> permissions;
        PosixFileAttributeView view;
        if (file == null) {
            NioFiles.$$$reportNull$$$0(9);
        }
        if ((view = Files.getFileAttributeView(file, PosixFileAttributeView.class, new LinkOption[0])) != null && (permissions = view.readAttributes().permissions()).add(PosixFilePermission.OWNER_EXECUTE)) {
            view.setPermissions(permissions);
        }
    }

    @NotNull
    public static List<Path> list(@NotNull Path directory) {
        ArrayList<Path> arrayList;
        if (directory == null) {
            NioFiles.$$$reportNull$$$0(10);
        }
        try {
            ArrayList<Path> files2 = new ArrayList<Path>();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory);){
                for (Path path : stream) {
                    files2.add(path);
                }
            }
            arrayList = files2;
        }
        catch (IOException e2) {
            List<Path> list = Collections.emptyList();
            if (list == null) {
                NioFiles.$$$reportNull$$$0(12);
            }
            return list;
        }
        if (arrayList == null) {
            NioFiles.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    public static void deleteRecursively(@NotNull Path fileOrDirectory) throws IOException {
        if (fileOrDirectory == null) {
            NioFiles.$$$reportNull$$$0(16);
        }
        FileUtilRt.deleteRecursively(fileOrDirectory, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/io/NioFiles";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDirectory";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/io/NioFiles";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDirectories";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createParentDirectories";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "readAttributes";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toPath";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFileName";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDirectories";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createParentDirectories";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isWritable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setReadOnly";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setExecutable";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "readAttributes";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "deleteRecursively";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

