/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source;

import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.LighterAST;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.impl.cache.RecordUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LightTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.java.IKeywordElementType;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public final class JavaLightTreeUtil {
    @Nullable
    @Contract(value="_,null->null")
    public static List<LighterASTNode> getArgList(@NotNull LighterAST tree, @Nullable LighterASTNode call2) {
        LighterASTNode anonClass;
        if (tree == null) {
            JavaLightTreeUtil.$$$reportNull$$$0(0);
        }
        LighterASTNode exprList = LightTreeUtil.firstChildOfType(tree, (anonClass = LightTreeUtil.firstChildOfType(tree, call2, JavaElementType.ANONYMOUS_CLASS)) != null ? anonClass : call2, JavaElementType.EXPRESSION_LIST);
        return exprList == null ? null : JavaLightTreeUtil.getExpressionChildren(tree, exprList);
    }

    @Nullable
    @Contract(value="_,null->null")
    public static String getNameIdentifierText(@NotNull LighterAST tree, @Nullable LighterASTNode idOwner) {
        LighterASTNode id;
        if (tree == null) {
            JavaLightTreeUtil.$$$reportNull$$$0(1);
        }
        return (id = LightTreeUtil.firstChildOfType(tree, idOwner, JavaTokenType.IDENTIFIER)) != null ? RecordUtil.intern(tree.getCharTable(), id) : null;
    }

    @NotNull
    public static List<LighterASTNode> getExpressionChildren(@NotNull LighterAST tree, @NotNull LighterASTNode node) {
        if (tree == null) {
            JavaLightTreeUtil.$$$reportNull$$$0(2);
        }
        if (node == null) {
            JavaLightTreeUtil.$$$reportNull$$$0(3);
        }
        List<LighterASTNode> list = LightTreeUtil.getChildrenOfType(tree, node, ElementType.EXPRESSION_BIT_SET);
        if (list == null) {
            JavaLightTreeUtil.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    public static LighterASTNode findExpressionChild(@NotNull LighterAST tree, @Nullable LighterASTNode node) {
        if (tree == null) {
            JavaLightTreeUtil.$$$reportNull$$$0(5);
        }
        return LightTreeUtil.firstChildOfType(tree, node, ElementType.EXPRESSION_BIT_SET);
    }

    @Nullable
    public static LighterASTNode skipParenthesesCastsDown(@NotNull LighterAST tree, @Nullable LighterASTNode node) {
        IElementType type;
        if (tree == null) {
            JavaLightTreeUtil.$$$reportNull$$$0(6);
        }
        while (!(node == null || (type = node.getTokenType()) != JavaElementType.PARENTH_EXPRESSION && type != JavaElementType.TYPE_CAST_EXPRESSION || type == JavaElementType.TYPE_CAST_EXPRESSION && JavaLightTreeUtil.isPrimitiveCast(tree, node))) {
            node = JavaLightTreeUtil.findExpressionChild(tree, node);
        }
        return node;
    }

    public static boolean isPrimitiveCast(@NotNull LighterAST tree, @NotNull LighterASTNode node) {
        LighterASTNode typeElement;
        if (tree == null) {
            JavaLightTreeUtil.$$$reportNull$$$0(7);
        }
        if (node == null) {
            JavaLightTreeUtil.$$$reportNull$$$0(8);
        }
        if ((typeElement = LightTreeUtil.firstChildOfType(tree, node, JavaElementType.TYPE)) != null) {
            LighterASTNode item = ContainerUtil.getOnlyItem(tree.getChildren(typeElement));
            return item != null && item.getTokenType() instanceof IKeywordElementType;
        }
        return false;
    }

    @Nullable
    public static LighterASTNode skipParenthesesDown(@NotNull LighterAST tree, @Nullable LighterASTNode expression2) {
        if (tree == null) {
            JavaLightTreeUtil.$$$reportNull$$$0(9);
        }
        while (expression2 != null && expression2.getTokenType() == JavaElementType.PARENTH_EXPRESSION) {
            expression2 = JavaLightTreeUtil.findExpressionChild(tree, expression2);
        }
        return expression2;
    }

    public static boolean hasExplicitModifier(@NotNull LighterAST tree, @Nullable LighterASTNode modifierListOwner, @NotNull IElementType modifierKeyword) {
        LighterASTNode modifierList2;
        if (tree == null) {
            JavaLightTreeUtil.$$$reportNull$$$0(10);
        }
        if (modifierKeyword == null) {
            JavaLightTreeUtil.$$$reportNull$$$0(11);
        }
        return LightTreeUtil.firstChildOfType(tree, modifierList2 = LightTreeUtil.firstChildOfType(tree, modifierListOwner, JavaElementType.MODIFIER_LIST), modifierKeyword) != null;
    }

    public static boolean isNullLiteralExpression(@NotNull LighterAST tree, @NotNull LighterASTNode node) {
        if (tree == null) {
            JavaLightTreeUtil.$$$reportNull$$$0(12);
        }
        if (node == null) {
            JavaLightTreeUtil.$$$reportNull$$$0(13);
        }
        return node.getTokenType() == JavaElementType.LITERAL_EXPRESSION && tree.getChildren(node).get(0).getTokenType() == JavaTokenType.NULL_KEYWORD;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 3: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/JavaLightTreeUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierKeyword";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/JavaLightTreeUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionChildren";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getArgList";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getNameIdentifierText";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionChildren";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findExpressionChild";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "skipParenthesesCastsDown";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isPrimitiveCast";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "skipParenthesesDown";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasExplicitModifier";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isNullLiteralExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

