/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.enterprise.impl.legacy;

import javax.inject.Inject;
import org.gradle.api.internal.BuildType;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.internal.enterprise.core.GradleEnterprisePluginManager;
import org.gradle.internal.enterprise.impl.legacy.DevelocityPluginCompatibility;
import org.gradle.internal.enterprise.impl.legacy.UnsupportedBuildScanPluginVersionException;
import org.gradle.internal.scan.config.BuildScanConfig;
import org.gradle.internal.scan.config.BuildScanConfigProvider;
import org.gradle.internal.scan.config.BuildScanPluginMetadata;
import org.gradle.internal.scan.eob.BuildScanEndOfBuildNotifier;
import org.gradle.util.internal.VersionNumber;

public class LegacyGradleEnterprisePluginCheckInService
implements BuildScanConfigProvider,
BuildScanEndOfBuildNotifier {
    public static final String FIRST_GRADLE_ENTERPRISE_PLUGIN_VERSION_DISPLAY = "3.0";
    public static final VersionNumber FIRST_GRADLE_ENTERPRISE_PLUGIN_VERSION = VersionNumber.parse((String)"3.0");
    private static final VersionNumber FIRST_VERSION_AWARE_OF_UNSUPPORTED = VersionNumber.parse((String)"1.11");
    private final GradleInternal gradle;
    private final GradleEnterprisePluginManager manager;
    private final BuildType buildType;

    @Inject
    public LegacyGradleEnterprisePluginCheckInService(GradleInternal gradle, GradleEnterprisePluginManager manager, BuildType buildType) {
        this.gradle = gradle;
        this.manager = manager;
        this.buildType = buildType;
    }

    @Override
    public BuildScanConfig collect(BuildScanPluginMetadata pluginMetadata) {
        if (this.manager.isPresent()) {
            throw new IllegalStateException("Configuration has already been collected.");
        }
        String pluginVersion = pluginMetadata.getVersion();
        VersionNumber pluginBaseVersion = VersionNumber.parse((String)pluginVersion).getBaseVersion();
        if (pluginBaseVersion.compareTo(FIRST_GRADLE_ENTERPRISE_PLUGIN_VERSION) < 0) {
            throw new UnsupportedBuildScanPluginVersionException("The Develocity plugin is not compatible with this version of Gradle.\nPlease see https://gradle.com/help/gradle-6-build-scan-plugin for more information.");
        }
        String unsupportedReason = DevelocityPluginCompatibility.getUnsupportedPluginMessage(pluginVersion);
        this.manager.unsupported();
        if (!LegacyGradleEnterprisePluginCheckInService.isPluginAwareOfUnsupported(pluginBaseVersion)) {
            throw new UnsupportedBuildScanPluginVersionException(unsupportedReason);
        }
        return new Config(Requestedness.from(this.gradle), new AttributesImpl(this.buildType), unsupportedReason);
    }

    @Override
    public void notify(BuildScanEndOfBuildNotifier.Listener listener) {
    }

    private static boolean isPluginAwareOfUnsupported(VersionNumber pluginVersion) {
        return pluginVersion.compareTo(FIRST_VERSION_AWARE_OF_UNSUPPORTED) >= 0;
    }

    private static class Config
    implements BuildScanConfig {
        private final Requestedness requestedness;
        private final String unsupported;
        private final BuildScanConfig.Attributes attributes;

        public Config(Requestedness requestedness, AttributesImpl attributes, String unsupported) {
            this.requestedness = requestedness;
            this.unsupported = unsupported;
            this.attributes = attributes;
        }

        @Override
        public boolean isEnabled() {
            return this.requestedness.enabled;
        }

        @Override
        public boolean isDisabled() {
            return this.requestedness.disabled;
        }

        @Override
        public String getUnsupportedMessage() {
            return this.unsupported;
        }

        @Override
        public BuildScanConfig.Attributes getAttributes() {
            return this.attributes;
        }
    }

    private static enum Requestedness {
        DEFAULTED(false, false),
        ENABLED(true, false),
        DISABLED(false, true);

        private final boolean enabled;
        private final boolean disabled;

        private Requestedness(boolean enabled, boolean disabled) {
            this.enabled = enabled;
            this.disabled = disabled;
        }

        private static Requestedness from(GradleInternal gradle) {
            StartParameterInternal startParameter = gradle.getStartParameter();
            if (startParameter.isNoBuildScan()) {
                return DISABLED;
            }
            if (startParameter.isBuildScan()) {
                return ENABLED;
            }
            return DEFAULTED;
        }
    }

    private static class AttributesImpl
    implements BuildScanConfig.Attributes {
        private final BuildType buildType;

        public AttributesImpl(BuildType buildType) {
            this.buildType = buildType;
        }

        @Override
        public boolean isRootProjectHasVcsMappings() {
            return false;
        }

        @Override
        public boolean isTaskExecutingBuild() {
            boolean forceTaskExecutingBuild = System.getProperty("org.gradle.internal.ide.scan") != null;
            return forceTaskExecutingBuild || this.buildType == BuildType.TASKS;
        }
    }
}

