/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.resolution.failure;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Describable;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.matching.AttributeMatcher;
import org.gradle.api.internal.capabilities.ImmutableCapability;
import org.gradle.internal.Cast;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.model.GraphSelectionCandidates;
import org.gradle.internal.component.model.VariantGraphResolveMetadata;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.jspecify.annotations.Nullable;

public final class ResolutionCandidateAssessor {
    private final ImmutableAttributes requestedAttributes;
    private final AttributeMatcher attributeMatcher;

    public ResolutionCandidateAssessor(AttributeContainerInternal requestedAttributes, AttributeMatcher attributeMatcher) {
        this.requestedAttributes = requestedAttributes.asImmutable();
        this.attributeMatcher = attributeMatcher;
    }

    public ImmutableAttributes getRequestedAttributes() {
        return this.requestedAttributes;
    }

    public List<AssessedCandidate> assessResolvedVariants(List<? extends ResolvedVariant> resolvedVariants) {
        return resolvedVariants.stream().map(variant -> this.assessCandidate(variant.asDescribable().getCapitalizedDisplayName(), variant.getCapabilities(), variant.getAttributes().asImmutable())).sorted(Comparator.comparing(AssessedCandidate::getDisplayName)).collect(Collectors.toList());
    }

    public List<AssessedCandidate> assessResolvedVariantStates(List<? extends VariantGraphResolveState> variantStates, ImmutableCapability defaultCapabilityForComponent) {
        return variantStates.stream().map(VariantGraphResolveState::getMetadata).map(variant -> {
            ImmutableCapabilities capabilities = variant.getCapabilities().orElse(defaultCapabilityForComponent);
            return this.assessCandidate(variant.getName(), capabilities, variant.getAttributes().asImmutable());
        }).sorted(Comparator.comparing(AssessedCandidate::getDisplayName)).collect(Collectors.toList());
    }

    public List<AssessedCandidate> assessNodeMetadatas(Set<VariantGraphResolveMetadata> nodes) {
        return nodes.stream().map(variant -> this.assessCandidate(variant.getName(), variant.getCapabilities(), variant.getAttributes().asImmutable())).sorted(Comparator.comparing(AssessedCandidate::getDisplayName)).collect(Collectors.toList());
    }

    public List<AssessedCandidate> assessGraphSelectionCandidates(GraphSelectionCandidates candidates) {
        return candidates.getVariantsForAttributeMatching().stream().map(VariantGraphResolveState::getMetadata).map(variantMetadata -> this.assessCandidate(variantMetadata.getName(), variantMetadata.getCapabilities(), variantMetadata.getAttributes())).sorted(Comparator.comparing(AssessedCandidate::getDisplayName)).collect(Collectors.toList());
    }

    public AssessedCandidate assessCandidate(String candidateName, ImmutableCapabilities candidateCapabilities, ImmutableAttributes candidateAttributes) {
        HashSet alreadyAssessed = new HashSet(candidateAttributes.keySet().size());
        ImmutableList.Builder compatible = ImmutableList.builder();
        ImmutableList.Builder incompatible = ImmutableList.builder();
        ImmutableList.Builder onlyOnConsumer = ImmutableList.builder();
        ImmutableList.Builder onlyOnProducer = ImmutableList.builder();
        Sets.union((Set)this.requestedAttributes.getAttributes().keySet(), (Set)candidateAttributes.getAttributes().keySet()).stream().sorted(Comparator.comparing(Attribute::getName)).forEach(attribute -> ResolutionCandidateAssessor.classifyAttribute(this.requestedAttributes, candidateAttributes, this.attributeMatcher, attribute, alreadyAssessed, compatible, incompatible, onlyOnConsumer, onlyOnProducer));
        return new AssessedCandidate(candidateName, (AttributeContainerInternal)candidateAttributes, candidateCapabilities, compatible.build(), incompatible.build(), onlyOnConsumer.build(), onlyOnProducer.build());
    }

    private static <T> void classifyAttribute(ImmutableAttributes requestedAttributes, ImmutableAttributes candidateAttributes, AttributeMatcher attributeMatcher, Attribute<T> attribute, Set<String> alreadyAssessed, ImmutableList.Builder<AssessedAttribute<?>> compatible, ImmutableList.Builder<AssessedAttribute<?>> incompatible, ImmutableList.Builder<AssessedAttribute<?>> onlyOnConsumer, ImmutableList.Builder<AssessedAttribute<?>> onlyOnProducer) {
        if (alreadyAssessed.add(attribute.getName())) {
            String attributeName = attribute.getName();
            AttributeValue consumerValue = requestedAttributes.findEntry(attributeName);
            AttributeValue producerValue = candidateAttributes.findEntry(attributeName);
            if (consumerValue.isPresent() && producerValue.isPresent()) {
                if (attributeMatcher.isMatchingValue(attribute, producerValue.coerce(attribute), consumerValue.coerce(attribute))) {
                    compatible.add(new AssessedAttribute(attribute, Cast.uncheckedCast((Object)consumerValue.get()), Cast.uncheckedCast((Object)producerValue.get())));
                } else {
                    incompatible.add(new AssessedAttribute(attribute, Cast.uncheckedCast((Object)consumerValue.get()), Cast.uncheckedCast((Object)producerValue.get())));
                }
            } else if (consumerValue.isPresent()) {
                onlyOnConsumer.add(new AssessedAttribute(attribute, Cast.uncheckedCast((Object)consumerValue.get()), null));
            } else if (producerValue.isPresent()) {
                onlyOnProducer.add(new AssessedAttribute(attribute, null, Cast.uncheckedCast((Object)producerValue.get())));
            }
        }
    }

    public static final class AssessedCandidate
    implements Describable {
        private final String name;
        private final ImmutableAttributes candidateAttributes;
        private final ImmutableCapabilities candidateCapabilities;
        private final ImmutableList<AssessedAttribute<?>> compatible;
        private final ImmutableList<AssessedAttribute<?>> incompatible;
        private final ImmutableList<AssessedAttribute<?>> onlyOnRequest;
        private final ImmutableList<AssessedAttribute<?>> onlyOnCandidate;

        private AssessedCandidate(String name, AttributeContainerInternal attributes, ImmutableCapabilities candidateCapabilities, ImmutableList<AssessedAttribute<?>> compatible, ImmutableList<AssessedAttribute<?>> incompatible, ImmutableList<AssessedAttribute<?>> onlyOnRequest, ImmutableList<AssessedAttribute<?>> onlyOnCandidate) {
            this.name = name;
            this.candidateAttributes = attributes.asImmutable();
            this.candidateCapabilities = candidateCapabilities;
            this.compatible = compatible;
            this.incompatible = incompatible;
            this.onlyOnRequest = onlyOnRequest;
            this.onlyOnCandidate = onlyOnCandidate;
        }

        public String getDisplayName() {
            return this.name;
        }

        public ImmutableAttributes getAllCandidateAttributes() {
            return this.candidateAttributes;
        }

        public ImmutableCapabilities getCandidateCapabilities() {
            return this.candidateCapabilities;
        }

        public ImmutableList<AssessedAttribute<?>> getCompatibleAttributes() {
            return this.compatible;
        }

        public ImmutableList<AssessedAttribute<?>> getIncompatibleAttributes() {
            return this.incompatible;
        }

        public ImmutableList<AssessedAttribute<?>> getOnlyOnRequestAttributes() {
            return this.onlyOnRequest;
        }

        public ImmutableList<AssessedAttribute<?>> getOnlyOnCandidateAttributes() {
            return this.onlyOnCandidate;
        }

        public boolean hasNoAttributes() {
            return this.getAllCandidateAttributes().isEmpty();
        }
    }

    public static final class AssessedAttribute<T> {
        private final Attribute<T> attribute;
        private final @Nullable T requested;
        private final @Nullable T provided;

        private AssessedAttribute(Attribute<T> attribute, @Nullable T requested, @Nullable T provided) {
            this.attribute = attribute;
            this.requested = requested;
            this.provided = provided;
        }

        public Attribute<T> getAttribute() {
            return this.attribute;
        }

        public @Nullable T getRequested() {
            return this.requested;
        }

        public @Nullable T getProvided() {
            return this.provided;
        }

        public String toString() {
            return "{name=" + this.attribute.getName() + ", type=" + this.attribute.getType() + ", requested=" + this.requested + ", provided=" + this.provided + '}';
        }
    }
}

