/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.gradle.buildinit.plugins.internal.AbstractBuildGenerator;
import org.gradle.buildinit.plugins.internal.BuildContentGenerationContext;
import org.gradle.buildinit.plugins.internal.BuildContentGenerator;
import org.gradle.buildinit.plugins.internal.CompositeProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.LanguageSpecificAdaptor;
import org.gradle.buildinit.plugins.internal.ProjectGenerator;
import org.gradle.buildinit.plugins.internal.SimpleGlobalFilesBuildSettingsDescriptor;
import org.gradle.buildinit.plugins.internal.VersionCatalogDependencyRegistry;
import org.gradle.buildinit.plugins.internal.VersionCatalogGenerator;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitDsl;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitTestFramework;
import org.gradle.buildinit.plugins.internal.modifiers.ComponentType;
import org.gradle.buildinit.plugins.internal.modifiers.Language;
import org.gradle.buildinit.plugins.internal.modifiers.ModularizationOption;

public class SourceGeneratingBuildGenerator
extends AbstractBuildGenerator
implements CompositeProjectInitDescriptor {
    private final ProjectGenerator descriptor;
    private final List<? extends BuildContentGenerator> generators;

    public SourceGeneratingBuildGenerator(ProjectGenerator projectGenerator, List<? extends BuildContentGenerator> generators) {
        super(projectGenerator, generators);
        this.generators = generators;
        this.descriptor = projectGenerator;
    }

    @Override
    public String getId() {
        return this.descriptor.getId();
    }

    @Override
    public ComponentType getComponentType() {
        return this.descriptor.getComponentType();
    }

    @Override
    public Language getLanguage() {
        return this.descriptor.getLanguage();
    }

    @Override
    public boolean productionCodeUses(Language language) {
        return this.descriptor.getLanguage().equals((Object)language);
    }

    @Override
    public List<String> getDefaultProjectNames() {
        return this.getComponentType().getDefaultProjectNames();
    }

    @Override
    public boolean supportsJavaTargets() {
        return this.descriptor.isJvmLanguage();
    }

    @Override
    public Set<ModularizationOption> getModularizationOptions() {
        return this.descriptor.getModularizationOptions();
    }

    @Override
    public boolean supportsPackage() {
        return this.descriptor.supportsPackage();
    }

    @Override
    public BuildInitDsl getDefaultDsl() {
        return this.descriptor.getDefaultDsl();
    }

    @Override
    public BuildInitTestFramework getDefaultTestFramework() {
        return this.getDefaultTestFramework(ModularizationOption.SINGLE_PROJECT);
    }

    @Override
    public BuildInitTestFramework getDefaultTestFramework(ModularizationOption modularizationOption) {
        return this.descriptor.getDefaultTestFramework(modularizationOption);
    }

    @Override
    public Set<BuildInitTestFramework> getTestFrameworks() {
        return this.getTestFrameworks(ModularizationOption.SINGLE_PROJECT);
    }

    @Override
    public Set<BuildInitTestFramework> getTestFrameworks(ModularizationOption modularizationOption) {
        return this.descriptor.getTestFrameworks(modularizationOption);
    }

    @Override
    public Optional<String> getFurtherReading(InitSettings settings) {
        return this.descriptor.getFurtherReading(settings);
    }

    @Override
    public Map<String, List<String>> generateWithExternalComments(InitSettings settings) {
        BuildContentGenerationContext buildContentGenerationContext = new BuildContentGenerationContext(new VersionCatalogDependencyRegistry(false));
        if (!(this.descriptor instanceof LanguageSpecificAdaptor)) {
            throw new UnsupportedOperationException();
        }
        for (BuildContentGenerator buildContentGenerator : this.generators) {
            if (buildContentGenerator instanceof SimpleGlobalFilesBuildSettingsDescriptor) {
                ((SimpleGlobalFilesBuildSettingsDescriptor)buildContentGenerator).generateWithoutComments(settings, buildContentGenerationContext);
                continue;
            }
            buildContentGenerator.generate(settings, buildContentGenerationContext);
        }
        Map<String, List<String>> comments = ((LanguageSpecificAdaptor)this.descriptor).generateWithExternalComments(settings, buildContentGenerationContext);
        VersionCatalogGenerator.create(settings.getTarget()).generate(buildContentGenerationContext, settings.isWithComments());
        return comments;
    }
}

