/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.internal.tasks;

import com.google.common.base.Joiner;
import com.google.common.collect.Streams;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Developer;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Relocation;
import org.apache.maven.model.Scm;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.gradle.api.XmlProvider;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MetaDataParser;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.provider.Provider;
import org.gradle.api.publish.maven.MavenPomCiManagement;
import org.gradle.api.publish.maven.MavenPomContributor;
import org.gradle.api.publish.maven.MavenPomDeveloper;
import org.gradle.api.publish.maven.MavenPomIssueManagement;
import org.gradle.api.publish.maven.MavenPomLicense;
import org.gradle.api.publish.maven.MavenPomMailingList;
import org.gradle.api.publish.maven.MavenPomOrganization;
import org.gradle.api.publish.maven.MavenPomRelocation;
import org.gradle.api.publish.maven.MavenPomScm;
import org.gradle.api.publish.maven.internal.dependencies.MavenDependency;
import org.gradle.api.publish.maven.internal.dependencies.MavenPomDependencies;
import org.gradle.api.publish.maven.internal.publication.MavenPomDistributionManagementInternal;
import org.gradle.api.publish.maven.internal.publication.MavenPomInternal;
import org.gradle.api.publish.maven.internal.publisher.MavenPublicationCoordinates;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.xml.XmlTransformer;
import org.gradle.util.internal.GUtil;

public final class MavenPomFileGenerator {
    private static final String POM_FILE_ENCODING = "UTF-8";
    private static final String POM_VERSION = "4.0.0";

    private MavenPomFileGenerator() {
    }

    public static MavenPomSpec generateSpec(MavenPomInternal pom) {
        Model model = new Model();
        model.setModelVersion(POM_VERSION);
        MavenPublicationCoordinates coordinates = pom.getCoordinates();
        model.setGroupId((String)coordinates.getGroupId().get());
        model.setArtifactId((String)coordinates.getArtifactId().get());
        model.setVersion((String)coordinates.getVersion().get());
        model.setPackaging((String)pom.getPackagingProperty().getOrNull());
        model.setName((String)pom.getName().getOrNull());
        model.setDescription((String)pom.getDescription().getOrNull());
        model.setUrl((String)pom.getUrl().getOrNull());
        model.setInceptionYear((String)pom.getInceptionYear().getOrNull());
        if (pom.getOrganization() != null) {
            model.setOrganization(MavenPomFileGenerator.convertOrganization(pom.getOrganization()));
        }
        if (pom.getScm() != null) {
            model.setScm(MavenPomFileGenerator.convertScm(pom.getScm()));
        }
        if (pom.getIssueManagement() != null) {
            model.setIssueManagement(MavenPomFileGenerator.convertIssueManagement(pom.getIssueManagement()));
        }
        if (pom.getCiManagement() != null) {
            model.setCiManagement(MavenPomFileGenerator.convertCiManagement(pom.getCiManagement()));
        }
        if (pom.getDistributionManagement() != null) {
            model.setDistributionManagement(MavenPomFileGenerator.convertDistributionManagement(pom.getDistributionManagement()));
        }
        for (MavenPomLicense mavenPomLicense : pom.getLicenses()) {
            model.addLicense(MavenPomFileGenerator.convertLicense(mavenPomLicense));
        }
        for (MavenPomDeveloper mavenPomDeveloper : pom.getDevelopers()) {
            model.addDeveloper(MavenPomFileGenerator.convertDeveloper(mavenPomDeveloper));
        }
        for (MavenPomContributor mavenPomContributor : pom.getContributors()) {
            model.addContributor(MavenPomFileGenerator.convertContributor(mavenPomContributor));
        }
        for (MavenPomMailingList mavenPomMailingList : pom.getMailingLists()) {
            model.addMailingList(MavenPomFileGenerator.convertMailingList(mavenPomMailingList));
        }
        for (Map.Entry entry : ((Map)pom.getProperties().get()).entrySet()) {
            model.addProperty((String)entry.getKey(), (String)entry.getValue());
        }
        MavenPomDependencies dependencies = (MavenPomDependencies)pom.getDependencies().getOrNull();
        if (dependencies != null) {
            model.setDependencyManagement(MavenPomFileGenerator.convertDependencyManagement(dependencies));
            model.setDependencies(MavenPomFileGenerator.convertDependencies(dependencies));
        }
        XmlTransformer xmlTransformer = new XmlTransformer();
        xmlTransformer.addAction(pom.getXmlAction());
        if (((Boolean)pom.getWriteGradleMetadataMarker().get()).booleanValue()) {
            xmlTransformer.addFinalizer(SerializableLambdas.action(MavenPomFileGenerator::insertGradleMetadataMarker));
        }
        return new MavenPomSpec(model, xmlTransformer);
    }

    private static Organization convertOrganization(MavenPomOrganization source) {
        Organization target = new Organization();
        target.setName((String)source.getName().getOrNull());
        target.setUrl((String)source.getUrl().getOrNull());
        return target;
    }

    private static License convertLicense(MavenPomLicense source) {
        License target = new License();
        target.setName((String)source.getName().getOrNull());
        target.setUrl((String)source.getUrl().getOrNull());
        target.setDistribution((String)source.getDistribution().getOrNull());
        target.setComments((String)source.getComments().getOrNull());
        return target;
    }

    private static Developer convertDeveloper(MavenPomDeveloper source) {
        Developer target = new Developer();
        target.setId((String)source.getId().getOrNull());
        target.setName((String)source.getName().getOrNull());
        target.setEmail((String)source.getEmail().getOrNull());
        target.setUrl((String)source.getUrl().getOrNull());
        target.setOrganization((String)source.getOrganization().getOrNull());
        target.setOrganizationUrl((String)source.getOrganizationUrl().getOrNull());
        target.setRoles(new ArrayList((Collection)source.getRoles().get()));
        target.setTimezone((String)source.getTimezone().getOrNull());
        target.setProperties(MavenPomFileGenerator.convertProperties(source.getProperties()));
        return target;
    }

    private static Contributor convertContributor(MavenPomContributor source) {
        Contributor target = new Contributor();
        target.setName((String)source.getName().getOrNull());
        target.setEmail((String)source.getEmail().getOrNull());
        target.setUrl((String)source.getUrl().getOrNull());
        target.setOrganization((String)source.getOrganization().getOrNull());
        target.setOrganizationUrl((String)source.getOrganizationUrl().getOrNull());
        target.setRoles(new ArrayList((Collection)source.getRoles().get()));
        target.setTimezone((String)source.getTimezone().getOrNull());
        target.setProperties(MavenPomFileGenerator.convertProperties(source.getProperties()));
        return target;
    }

    private static Properties convertProperties(Provider<Map<String, String>> source) {
        Properties target = new Properties();
        target.putAll((Map<?, ?>)((Map)source.getOrElse(Collections.emptyMap())));
        return target;
    }

    private static Scm convertScm(MavenPomScm source) {
        Scm target = new Scm();
        target.setConnection((String)source.getConnection().getOrNull());
        target.setDeveloperConnection((String)source.getDeveloperConnection().getOrNull());
        target.setUrl((String)source.getUrl().getOrNull());
        target.setTag((String)source.getTag().getOrNull());
        return target;
    }

    private static IssueManagement convertIssueManagement(MavenPomIssueManagement source) {
        IssueManagement target = new IssueManagement();
        target.setSystem((String)source.getSystem().getOrNull());
        target.setUrl((String)source.getUrl().getOrNull());
        return target;
    }

    private static CiManagement convertCiManagement(MavenPomCiManagement source) {
        CiManagement target = new CiManagement();
        target.setSystem((String)source.getSystem().getOrNull());
        target.setUrl((String)source.getUrl().getOrNull());
        return target;
    }

    private static DistributionManagement convertDistributionManagement(MavenPomDistributionManagementInternal source) {
        DistributionManagement target = new DistributionManagement();
        target.setDownloadUrl((String)source.getDownloadUrl().getOrNull());
        if (source.getRelocation() != null) {
            target.setRelocation(MavenPomFileGenerator.convertRelocation(source.getRelocation()));
        }
        return target;
    }

    private static Relocation convertRelocation(MavenPomRelocation source) {
        Relocation target = new Relocation();
        target.setGroupId((String)source.getGroupId().getOrNull());
        target.setArtifactId((String)source.getArtifactId().getOrNull());
        target.setVersion((String)source.getVersion().getOrNull());
        target.setMessage((String)source.getMessage().getOrNull());
        return target;
    }

    private static MailingList convertMailingList(MavenPomMailingList source) {
        MailingList target = new MailingList();
        target.setName((String)source.getName().getOrNull());
        target.setSubscribe((String)source.getSubscribe().getOrNull());
        target.setUnsubscribe((String)source.getUnsubscribe().getOrNull());
        target.setPost((String)source.getPost().getOrNull());
        target.setArchive((String)source.getArchive().getOrNull());
        target.setOtherArchives(new ArrayList((Collection)source.getOtherArchives().get()));
        return target;
    }

    private static DependencyManagement convertDependencyManagement(MavenPomDependencies dependencies) {
        if (dependencies.getDependencyManagement().isEmpty()) {
            return null;
        }
        List converted = dependencies.getDependencyManagement().stream().map(MavenPomFileGenerator::convertDependencyManagementDependency).collect(Collectors.toList());
        DependencyManagement dm = new DependencyManagement();
        dm.setDependencies(converted);
        return dm;
    }

    private static List<Dependency> convertDependencies(MavenPomDependencies dependencies) {
        return dependencies.getDependencies().stream().map(MavenPomFileGenerator::convertDependency).collect(Collectors.toList());
    }

    private static Dependency convertDependency(MavenDependency dependency) {
        Dependency mavenDependency = new Dependency();
        mavenDependency.setGroupId(dependency.getGroupId());
        mavenDependency.setArtifactId(dependency.getArtifactId());
        mavenDependency.setVersion(dependency.getVersion());
        mavenDependency.setType(dependency.getType());
        mavenDependency.setScope(dependency.getScope());
        mavenDependency.setClassifier(dependency.getClassifier());
        if (dependency.isOptional()) {
            mavenDependency.setOptional(true);
        }
        for (ExcludeRule excludeRule : dependency.getExcludeRules()) {
            Exclusion exclusion = new Exclusion();
            exclusion.setGroupId((String)GUtil.elvis((Object)excludeRule.getGroup(), (Object)"*"));
            exclusion.setArtifactId((String)GUtil.elvis((Object)excludeRule.getModule(), (Object)"*"));
            mavenDependency.addExclusion(exclusion);
        }
        return mavenDependency;
    }

    private static Dependency convertDependencyManagementDependency(MavenDependency dependency) {
        Dependency mavenDependency = new Dependency();
        mavenDependency.setGroupId(dependency.getGroupId());
        mavenDependency.setArtifactId(dependency.getArtifactId());
        mavenDependency.setVersion(dependency.getVersion());
        String type = dependency.getType();
        if (type != null) {
            mavenDependency.setType(type);
        }
        mavenDependency.setScope(dependency.getScope());
        return mavenDependency;
    }

    private static void insertGradleMetadataMarker(XmlProvider xmlProvider) {
        String comment = Joiner.on((String)"").join(Streams.concat((Stream[])new Stream[]{Arrays.stream(MetaDataParser.GRADLE_METADATA_MARKER_COMMENT_LINES), Stream.of("do_not_remove: published-with-gradle-metadata")}).map(content -> "<!-- " + content + " -->\n  ").iterator());
        StringBuilder builder = xmlProvider.asString();
        int idx = builder.indexOf("<modelVersion");
        builder.insert(idx, comment);
    }

    public static class MavenPomSpec {
        private final Model model;
        private final XmlTransformer xmlTransformer;

        public MavenPomSpec(Model model, XmlTransformer xmlTransformer) {
            this.model = model;
            this.xmlTransformer = xmlTransformer;
        }

        public void writeTo(File file) {
            this.xmlTransformer.transform(file, MavenPomFileGenerator.POM_FILE_ENCODING, writer -> {
                try {
                    new MavenXpp3Writer().write(writer, this.model);
                }
                catch (IOException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            });
        }
    }
}

