/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.DependencyManagementServices;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.initialization.BuildLogicBuilder;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.DefaultScriptHandler;
import org.gradle.api.internal.initialization.ScriptHandlerFactory;
import org.gradle.api.internal.initialization.ScriptHandlerInternal;
import org.gradle.groovy.scripts.ScriptSource;

public class DefaultScriptHandlerFactory
implements ScriptHandlerFactory {
    private final DependencyManagementServices dependencyManagementServices;
    private final BuildLogicBuilder buildLogicBuilder;

    public DefaultScriptHandlerFactory(DependencyManagementServices dependencyManagementServices, BuildLogicBuilder buildLogicBuilder) {
        this.dependencyManagementServices = dependencyManagementServices;
        this.buildLogicBuilder = buildLogicBuilder;
    }

    @Override
    public ScriptHandlerInternal create(ScriptSource scriptSource, ClassLoaderScope classLoaderScope, DomainObjectContext owner) {
        DependencyResolutionServices services = this.dependencyManagementServices.newDetachedResolver(owner);
        return this.getDefaultScriptHandler(scriptSource, classLoaderScope, services);
    }

    @Override
    public ScriptHandlerInternal create(ScriptSource scriptSource, ClassLoaderScope classLoaderScope, FileResolver fileResolver, FileCollectionFactory fileCollectionFactory, DomainObjectContext owner) {
        DependencyResolutionServices services = this.dependencyManagementServices.newDetachedResolver(fileResolver, fileCollectionFactory, owner);
        return this.getDefaultScriptHandler(scriptSource, classLoaderScope, services);
    }

    private DefaultScriptHandler getDefaultScriptHandler(ScriptSource scriptSource, ClassLoaderScope classLoaderScope, DependencyResolutionServices services) {
        return (DefaultScriptHandler)services.getObjectFactory().newInstance(DefaultScriptHandler.class, new Object[]{scriptSource, services, classLoaderScope, this.buildLogicBuilder});
    }
}

