/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization.loadercache;

import java.util.Collection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.internal.classloader.ClasspathHasher;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.execution.FileCollectionFingerprinter;
import org.gradle.internal.execution.FileCollectionSnapshotter;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.FileSystemSnapshot;

public class DefaultClasspathHasher
implements ClasspathHasher {
    private final FileCollectionSnapshotter snapshotter;
    private final FileCollectionFingerprinter fingerprinter;
    private final FileCollectionFactory fileCollectionFactory;

    public DefaultClasspathHasher(FileCollectionSnapshotter snapshotter, FileCollectionFingerprinter fingerprinter, FileCollectionFactory fileCollectionFactory) {
        this.snapshotter = snapshotter;
        this.fingerprinter = fingerprinter;
        this.fileCollectionFactory = fileCollectionFactory;
    }

    public HashCode hash(ClassPath classpath) {
        FileSystemSnapshot snapshot = this.snapshotter.snapshot((FileCollection)this.fileCollectionFactory.fixed((Collection)classpath.getAsFiles()));
        CurrentFileCollectionFingerprint fingerprint = this.fingerprinter.fingerprint(snapshot, null);
        return fingerprint.getHash();
    }
}

