/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.internal.provider.CollectionProviderInternal;
import org.gradle.api.internal.provider.Collector;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.ValueCollector;
import org.gradle.api.internal.provider.ValueSanitizers;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.provider.Provider;
import org.jspecify.annotations.Nullable;

public class Collectors {
    private static <T> ValueSupplier.ExecutionTimeValue<? extends Iterable<? extends T>> visitValue(ValueSupplier.ExecutionTimeValue<? extends T> value) {
        if (value.isMissing()) {
            return ValueSupplier.ExecutionTimeValue.missing();
        }
        if (value.hasFixedValue()) {
            return ValueSupplier.ExecutionTimeValue.value(value.toValue().transform(ImmutableList::of));
        }
        return ValueSupplier.ExecutionTimeValue.changingValue(value.getChangingValue().map(SerializableLambdas.transformer(ImmutableList::of)));
    }

    public static class TypedCollector<T>
    implements ProvidedCollector<T> {
        private final Class<? extends T> type;
        protected final Collector<T> delegate;
        private final ValueCollector<T> valueCollector;

        public TypedCollector(@Nullable Class<? extends T> type, Collector<T> delegate) {
            this.type = type;
            this.delegate = delegate;
            this.valueCollector = ValueSanitizers.collectorFor(type);
        }

        public @Nullable Class<? extends T> getType() {
            return this.type;
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return this.delegate.calculatePresence(consumer);
        }

        public void collectInto(ImmutableCollection.Builder<T> builder) {
            this.collectEntries(ValueSupplier.ValueConsumer.IgnoreUnsafeRead, this.valueCollector, builder);
        }

        @Override
        public ValueSupplier.Value<Void> collectEntries(ValueSupplier.ValueConsumer consumer, ValueCollector<T> collector, ImmutableCollection.Builder<T> dest) {
            return this.delegate.collectEntries(consumer, collector, dest);
        }

        @Override
        public boolean isProvidedBy(Provider<?> provider) {
            return this.delegate instanceof ProvidedCollector && ((ProvidedCollector)this.delegate).isProvidedBy(provider);
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends Iterable<? extends T>> calculateExecutionTimeValue() {
            return this.delegate.calculateExecutionTimeValue();
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return this.delegate.getProducer();
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypedCollector that = (TypedCollector)o;
            return Objects.equal(this.type, that.type) && Objects.equal(this.delegate, that.delegate);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.type, this.delegate});
        }

        public String toString() {
            return String.format("(%s as %s)", this.delegate, this.type);
        }
    }

    public static class ElementsFromArray<T>
    implements Collector<T> {
        private final T[] value;

        ElementsFromArray(T[] value) {
            this.value = value;
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return true;
        }

        @Override
        public ValueSupplier.Value<Void> collectEntries(ValueSupplier.ValueConsumer consumer, ValueCollector<T> collector, ImmutableCollection.Builder<T> dest) {
            for (T t : this.value) {
                collector.add(t, dest);
            }
            return ValueSupplier.Value.present();
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends Iterable<? extends T>> calculateExecutionTimeValue() {
            return ValueSupplier.ExecutionTimeValue.fixedValue(ImmutableList.copyOf((Object[])this.value));
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return ValueSupplier.ValueProducer.unknown();
        }

        @Override
        public int size() {
            return this.value.length;
        }

        public String toString() {
            return Arrays.toString(this.value);
        }
    }

    public static class ElementsFromCollectionProvider<T>
    implements ProvidedCollector<T> {
        private final ProviderInternal<? extends Iterable<? extends T>> provider;

        public ElementsFromCollectionProvider(ProviderInternal<? extends Iterable<? extends T>> provider) {
            this.provider = provider;
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return this.provider.calculatePresence(consumer);
        }

        @Override
        public ValueSupplier.Value<Void> collectEntries(ValueSupplier.ValueConsumer consumer, ValueCollector<T> collector, ImmutableCollection.Builder<T> collection) {
            ValueSupplier.Value<? extends Iterable<? extends T>> value = this.provider.calculateValue(consumer);
            return this.collectEntriesFromValue(collector, collection, value);
        }

        private ValueSupplier.Value<Void> collectEntriesFromValue(ValueCollector<T> collector, ImmutableCollection.Builder<T> collection, ValueSupplier.Value<? extends Iterable<? extends T>> value) {
            if (value.isMissing()) {
                return value.asType();
            }
            collector.addAll(value.getWithoutSideEffect(), collection);
            return ValueSupplier.Value.present().withSideEffect(ValueSupplier.SideEffect.fixedFrom(value));
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends Iterable<? extends T>> calculateExecutionTimeValue() {
            return this.provider.calculateExecutionTimeValue();
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return this.provider.getProducer();
        }

        @Override
        public boolean isProvidedBy(Provider<?> provider) {
            return Objects.equal(this.provider, provider);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ElementsFromCollectionProvider that = (ElementsFromCollectionProvider)o;
            return Objects.equal(this.provider, that.provider);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.provider});
        }

        @Override
        public int size() {
            if (this.provider instanceof CollectionProviderInternal) {
                return ((CollectionProviderInternal)this.provider).size();
            }
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return String.valueOf(this.provider);
        }
    }

    public static class ElementsFromCollection<T>
    implements Collector<T> {
        private final Iterable<? extends T> value;

        public ElementsFromCollection(Iterable<? extends T> value) {
            this.value = value;
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return true;
        }

        @Override
        public ValueSupplier.Value<Void> collectEntries(ValueSupplier.ValueConsumer consumer, ValueCollector<T> collector, ImmutableCollection.Builder<T> collection) {
            collector.addAll(this.value, collection);
            return ValueSupplier.Value.present();
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends Iterable<? extends T>> calculateExecutionTimeValue() {
            return ValueSupplier.ExecutionTimeValue.fixedValue(this.value);
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return ValueSupplier.ValueProducer.unknown();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ElementsFromCollection that = (ElementsFromCollection)o;
            boolean result = Objects.equal(this.value, that.value);
            return result;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.value});
        }

        @Override
        public int size() {
            return Iterables.size(this.value);
        }

        public String toString() {
            return this.value.toString();
        }
    }

    public static class ElementFromProvider<T>
    implements ProvidedCollector<T> {
        private final ProviderInternal<? extends T> provider;

        public ElementFromProvider(ProviderInternal<? extends T> provider) {
            this.provider = provider;
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return this.provider.calculatePresence(consumer);
        }

        @Override
        public ValueSupplier.Value<Void> collectEntries(ValueSupplier.ValueConsumer consumer, ValueCollector<T> collector, ImmutableCollection.Builder<T> collection) {
            ValueSupplier.Value<T> value = this.provider.calculateValue(consumer);
            if (value.isMissing()) {
                return value.asType();
            }
            collector.add(value.getWithoutSideEffect(), collection);
            return ValueSupplier.Value.present().withSideEffect(ValueSupplier.SideEffect.fixedFrom(value));
        }

        @Override
        public boolean isProvidedBy(Provider<?> provider) {
            return Objects.equal(provider, this.provider);
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends Iterable<? extends T>> calculateExecutionTimeValue() {
            ValueSupplier.ExecutionTimeValue<? extends T> value = this.provider.calculateExecutionTimeValue();
            return Collectors.visitValue(value);
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return this.provider.getProducer();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ElementFromProvider that = (ElementFromProvider)o;
            return Objects.equal(this.provider, that.provider);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.provider});
        }

        @Override
        public int size() {
            return 1;
        }

        public String toString() {
            return String.format("item(%s)", this.provider);
        }
    }

    public static class SingleElement<T>
    implements Collector<T> {
        private final T element;

        public SingleElement(T element) {
            this.element = element;
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return true;
        }

        @Override
        public ValueSupplier.Value<Void> collectEntries(ValueSupplier.ValueConsumer consumer, ValueCollector<T> collector, ImmutableCollection.Builder<T> collection) {
            collector.add(this.element, collection);
            return ValueSupplier.Value.present();
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends Iterable<? extends T>> calculateExecutionTimeValue() {
            return ValueSupplier.ExecutionTimeValue.fixedValue(ImmutableList.of(this.element));
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return ValueSupplier.ValueProducer.unknown();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SingleElement that = (SingleElement)o;
            return Objects.equal(this.element, that.element);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.element});
        }

        @Override
        public int size() {
            return 1;
        }

        public String toString() {
            return String.format("[%s]", this.element);
        }
    }

    public static interface ProvidedCollector<T>
    extends Collector<T> {
        public boolean isProvidedBy(Provider<?> var1);
    }
}

