/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider.views;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.gradle.api.provider.MapProperty;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class MapPropertyMapView<K, V>
extends AbstractMap<K, V> {
    private final MapProperty<K, V> delegate;

    public MapPropertyMapView(MapProperty<K, V> delegate) {
        this.delegate = delegate;
    }

    @Override
    public @Nullable V get(Object key) {
        return ((Map)this.delegate.get()).get(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return ((Map)this.delegate.get()).containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return ((Map)this.delegate.get()).containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public @Nullable V put(K key, V value) {
        V oldValue = this.get(key);
        this.delegate.put(key, value);
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.delegate.putAll(m);
    }

    @Override
    public @Nullable V remove(Object key) {
        LinkedHashMap map = new LinkedHashMap((Map)this.delegate.get());
        Object oldValue = map.remove(key);
        this.delegate.set(map);
        return oldValue;
    }

    @Override
    public void clear() {
        this.delegate.empty();
    }

    @Override
    public int size() {
        return ((Map)this.delegate.get()).size();
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public boolean remove(Object o) {
            Map.Entry entry;
            Object value;
            if (o instanceof Map.Entry && MapPropertyMapView.this.containsKey(((Map.Entry)o).getKey()) && Objects.equals(value = MapPropertyMapView.this.get((entry = (Map.Entry)o).getKey()), entry.getValue())) {
                MapPropertyMapView.this.remove(entry.getKey());
                return true;
            }
            return false;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            final Iterator it = new LinkedHashMap((Map)MapPropertyMapView.this.delegate.get()).entrySet().iterator();
            return new Iterator<Map.Entry<K, V>>(){
                Map.Entry<K, V> previousValue = null;

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public Map.Entry<K, V> next() {
                    this.previousValue = (Map.Entry)it.next();
                    return this.previousValue;
                }

                @Override
                public void remove() {
                    it.remove();
                    MapPropertyMapView.this.remove(this.previousValue.getKey());
                }
            };
        }

        @Override
        public int size() {
            return MapPropertyMapView.this.size();
        }
    }
}

