/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.CircularReferenceException;
import org.gradle.api.artifacts.component.LibraryBinaryIdentifier;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.resolve.ProjectModelResolver;
import org.gradle.api.reporting.dependents.internal.DependentComponentsUtils;
import org.gradle.internal.build.BuildProjectRegistry;
import org.gradle.internal.graph.DirectedGraph;
import org.gradle.internal.graph.DirectedGraphRenderer;
import org.gradle.internal.graph.GraphNodeRenderer;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.model.ModelMap;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.type.ModelTypes;
import org.gradle.nativeplatform.NativeComponentSpec;
import org.gradle.nativeplatform.NativeLibraryBinary;
import org.gradle.nativeplatform.internal.NativeBinarySpecInternal;
import org.gradle.platform.base.VariantComponentSpec;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.platform.base.internal.dependents.AbstractDependentBinariesResolutionStrategy;
import org.gradle.platform.base.internal.dependents.DefaultDependentBinariesResolvedResult;
import org.gradle.platform.base.internal.dependents.DependentBinariesResolvedResult;

public class NativeDependentBinariesResolutionStrategy
extends AbstractDependentBinariesResolutionStrategy {
    public static final String NAME = "native";
    private final BuildProjectRegistry projectRegistry;
    private final ProjectModelResolver projectModelResolver;
    private final Cache<String, State> stateCache = CacheBuilder.newBuilder().maximumSize(1L).expireAfterAccess(10L, TimeUnit.SECONDS).build();
    private final Cache<NativeBinarySpecInternal, List<DependentBinariesResolvedResult>> resultsCache = CacheBuilder.newBuilder().maximumSize(3000L).expireAfterAccess(10L, TimeUnit.SECONDS).build();
    private TestSupport testSupport;

    public NativeDependentBinariesResolutionStrategy(BuildProjectRegistry projectRegistry, ProjectModelResolver projectModelResolver) {
        Preconditions.checkNotNull((Object)projectRegistry, (Object)"ProjectRegistry must not be null");
        Preconditions.checkNotNull((Object)projectModelResolver, (Object)"ProjectModelResolver must not be null");
        this.projectRegistry = projectRegistry;
        this.projectModelResolver = projectModelResolver;
    }

    public String getName() {
        return NAME;
    }

    public void setTestSupport(TestSupport testSupport) {
        this.testSupport = testSupport;
    }

    @Nullable
    protected List<DependentBinariesResolvedResult> resolveDependents(BinarySpecInternal target) {
        if (!(target instanceof NativeBinarySpecInternal)) {
            return null;
        }
        return this.resolveDependentBinaries((NativeBinarySpecInternal)target);
    }

    private List<DependentBinariesResolvedResult> resolveDependentBinaries(NativeBinarySpecInternal target) {
        State state = this.getState();
        return this.buildResolvedResult(target, state);
    }

    private State getState() {
        try {
            return (State)this.stateCache.get((Object)"state", (Callable)new Callable<State>(){

                @Override
                public State call() {
                    return NativeDependentBinariesResolutionStrategy.this.buildState();
                }
            });
        }
        catch (ExecutionException ex) {
            throw new RuntimeException("Unable to build native dependent binaries resolution cache", ex);
        }
    }

    private State buildState() {
        State state = new State();
        List orderedProjects = Ordering.usingToString().sortedCopy((Iterable)this.projectRegistry.getAllProjects().stream().map(ProjectState::getMutableModel).collect(Collectors.toList()));
        for (ProjectInternal project : orderedProjects) {
            if (!project.getPlugins().hasPlugin(ComponentModelBasePlugin.class)) continue;
            ModelRegistry modelRegistry = this.projectModelResolver.resolveProjectModel(project.getPath());
            ModelMap components = (ModelMap)modelRegistry.realize("components", ModelTypes.modelMap(NativeComponentSpec.class));
            for (NativeBinarySpecInternal binary : this.allBinariesOf((ModelMap<VariantComponentSpec>)components.withType(VariantComponentSpec.class))) {
                state.registerBinary(binary);
            }
            ModelMap testSuites = (ModelMap)modelRegistry.find("testSuites", ModelTypes.modelMap(Object.class));
            if (testSuites == null) continue;
            for (NativeBinarySpecInternal binary : this.allBinariesOf((ModelMap<VariantComponentSpec>)testSuites.withType(NativeComponentSpec.class).withType(VariantComponentSpec.class))) {
                state.registerBinary(binary);
            }
        }
        for (NativeBinarySpecInternal nativeBinary : state.dependencies.keySet()) {
            for (NativeLibraryBinary libraryBinary : nativeBinary.getDependentBinaries()) {
                if (!(libraryBinary instanceof NativeBinarySpecInternal)) continue;
                ((Set)state.dependencies.get(nativeBinary)).add((NativeBinarySpecInternal)((Object)libraryBinary));
            }
            if (this.testSupport == null) continue;
            ((Set)state.dependencies.get(nativeBinary)).addAll(this.testSupport.getTestDependencies(nativeBinary));
        }
        return state;
    }

    protected boolean isTestSuite(BinarySpecInternal target) {
        return this.testSupport != null && this.testSupport.isTestSuite(target);
    }

    private List<NativeBinarySpecInternal> allBinariesOf(ModelMap<VariantComponentSpec> components) {
        ArrayList binaries = Lists.newArrayList();
        for (VariantComponentSpec nativeComponent : components) {
            for (NativeBinarySpecInternal nativeBinary : nativeComponent.getBinaries().withType(NativeBinarySpecInternal.class)) {
                binaries.add(nativeBinary);
            }
        }
        return binaries;
    }

    private List<DependentBinariesResolvedResult> buildResolvedResult(NativeBinarySpecInternal target, State state) {
        ArrayDeque<NativeBinarySpecInternal> stack = new ArrayDeque<NativeBinarySpecInternal>();
        return this.doBuildResolvedResult(target, state, stack);
    }

    private List<DependentBinariesResolvedResult> doBuildResolvedResult(NativeBinarySpecInternal target, State state, Deque<NativeBinarySpecInternal> stack) {
        List result;
        if (stack.contains(target)) {
            this.onCircularDependencies(state, stack, target);
        }
        if ((result = (List)this.resultsCache.getIfPresent((Object)target)) != null) {
            return result;
        }
        stack.push(target);
        result = Lists.newArrayList();
        List<NativeBinarySpecInternal> dependents = state.getDependents(target);
        for (NativeBinarySpecInternal dependent : dependents) {
            List<DependentBinariesResolvedResult> children = this.doBuildResolvedResult(dependent, state, stack);
            result.add(new DefaultDependentBinariesResolvedResult(dependent.getId(), dependent.getProjectScopedName(), dependent.isBuildable(), this.isTestSuite(dependent), children));
        }
        stack.pop();
        this.resultsCache.put((Object)target, (Object)result);
        return result;
    }

    private void onCircularDependencies(final State state, final Deque<NativeBinarySpecInternal> stack, NativeBinarySpecInternal target) {
        GraphNodeRenderer<NativeBinarySpecInternal> nodeRenderer = new GraphNodeRenderer<NativeBinarySpecInternal>(){

            public void renderTo(NativeBinarySpecInternal node, StyledTextOutput output) {
                String name = DependentComponentsUtils.getBuildScopedTerseName((LibraryBinaryIdentifier)node.getId());
                output.withStyle(StyledTextOutput.Style.Identifier).text((Object)name);
            }
        };
        DirectedGraph<NativeBinarySpecInternal, Object> directedGraph = new DirectedGraph<NativeBinarySpecInternal, Object>(){

            public void getNodeValues(NativeBinarySpecInternal node, Collection<? super Object> values, Collection<? super NativeBinarySpecInternal> connectedNodes) {
                for (NativeBinarySpecInternal binary : stack) {
                    if (!state.getDependents(node).contains(binary)) continue;
                    connectedNodes.add(binary);
                }
            }
        };
        DirectedGraphRenderer graphRenderer = new DirectedGraphRenderer((GraphNodeRenderer)nodeRenderer, (DirectedGraph)directedGraph);
        StringWriter writer = new StringWriter();
        graphRenderer.renderTo((Object)target, (Appendable)writer);
        throw new CircularReferenceException(String.format("Circular dependency between the following binaries:%n%s", writer.toString()));
    }

    private static class State {
        private final Map<NativeBinarySpecInternal, Set<NativeBinarySpecInternal>> dependencies = Maps.newLinkedHashMap();
        private final Map<NativeBinarySpecInternal, List<NativeBinarySpecInternal>> dependents = Maps.newHashMap();

        private State() {
        }

        void registerBinary(NativeBinarySpecInternal binary) {
            if (this.dependencies.get(binary) == null) {
                this.dependencies.put(binary, Sets.newLinkedHashSet());
            }
        }

        List<NativeBinarySpecInternal> getDependents(NativeBinarySpecInternal target) {
            ArrayList result = this.dependents.get(target);
            if (result == null) {
                result = Lists.newArrayList();
                for (NativeBinarySpecInternal dependentBinary : this.dependencies.keySet()) {
                    if (!this.dependencies.get(dependentBinary).contains(target)) continue;
                    result.add(dependentBinary);
                }
                this.dependents.put(target, result);
            }
            return result;
        }
    }

    public static interface TestSupport {
        public boolean isTestSuite(BinarySpecInternal var1);

        public List<NativeBinarySpecInternal> getTestDependencies(NativeBinarySpecInternal var1);
    }
}

