/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath.intercept;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.gradle.api.NonNullApi;
import org.gradle.internal.classpath.GroovyCallInterceptorsProvider;
import org.gradle.internal.classpath.JvmBytecodeInterceptorSet;
import org.gradle.internal.classpath.intercept.CallInterceptorsSet;
import org.gradle.internal.classpath.intercept.CallSiteDecorator;

@NonNullApi
public class CallInterceptorRegistry {
    private static final Map<ClassLoader, Boolean> LOADED_FROM_CLASSLOADERS = Collections.synchronizedMap(new WeakHashMap());
    private static volatile CallSiteDecorator currentGroovyCallDecorator = new CallInterceptorsSet(GroovyCallInterceptorsProvider.DEFAULT);
    private static volatile JvmBytecodeInterceptorSet currentJvmBytecodeInterceptors = JvmBytecodeInterceptorSet.DEFAULT;

    public static synchronized void loadCallInterceptors(ClassLoader classLoader) {
        if (LOADED_FROM_CLASSLOADERS.put(classLoader, true) != null) {
            throw new RuntimeException("Cannot load interceptors twice for class loader: " + classLoader);
        }
        GroovyCallInterceptorsProvider.ClassLoaderSourceGroovyCallInterceptorsProvider classLoaderGroovyCallInterceptors = new GroovyCallInterceptorsProvider.ClassLoaderSourceGroovyCallInterceptorsProvider(classLoader);
        GroovyCallInterceptorsProvider callInterceptors = GroovyCallInterceptorsProvider.DEFAULT.plus(classLoaderGroovyCallInterceptors);
        currentGroovyCallDecorator = new CallInterceptorsSet(callInterceptors);
        JvmBytecodeInterceptorSet.ClassLoaderSourceJvmBytecodeInterceptorSet classLoaderJvmBytecodeInterceptors = new JvmBytecodeInterceptorSet.ClassLoaderSourceJvmBytecodeInterceptorSet(classLoader);
        currentJvmBytecodeInterceptors = JvmBytecodeInterceptorSet.DEFAULT.plus(classLoaderJvmBytecodeInterceptors);
    }

    public static CallSiteDecorator getGroovyCallDecorator() {
        return currentGroovyCallDecorator;
    }

    public static JvmBytecodeInterceptorSet getJvmBytecodeInterceptors() {
        return currentJvmBytecodeInterceptors;
    }

    @NonNullApi
    @VisibleForTesting
    static class GroovyCallInterceptorInternalTesting {
        GroovyCallInterceptorInternalTesting() {
        }

        static CallSiteDecorator getCurrentGroovyCallSiteDecorator() {
            return CallInterceptorRegistry.getGroovyCallDecorator();
        }

        static void setCurrentGroovyCallSiteDecorator(CallSiteDecorator interceptorsSet) {
            currentGroovyCallDecorator = interceptorsSet;
        }
    }
}

