/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.NonNullApi;
import org.gradle.internal.Cast;
import org.gradle.internal.classpath.Instrumented;
import org.gradle.internal.classpath.intercept.CallInterceptor;
import org.gradle.internal.lazy.Lazy;

@NonNullApi
public interface GroovyCallInterceptorsProvider {
    public static final GroovyCallInterceptorsProvider DEFAULT = new ClassSourceGroovyCallInterceptorsProvider(Instrumented.class.getName());

    public List<CallInterceptor> getCallInterceptors();

    default public GroovyCallInterceptorsProvider plus(GroovyCallInterceptorsProvider other) {
        return new CompositeGroovyCallInterceptorsProvider(this, other);
    }

    @NonNullApi
    public static class CompositeGroovyCallInterceptorsProvider
    implements GroovyCallInterceptorsProvider {
        private final GroovyCallInterceptorsProvider first;
        private final GroovyCallInterceptorsProvider second;

        private CompositeGroovyCallInterceptorsProvider(GroovyCallInterceptorsProvider first, GroovyCallInterceptorsProvider second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public List<CallInterceptor> getCallInterceptors() {
            return Stream.concat(this.first.getCallInterceptors().stream(), this.second.getCallInterceptors().stream()).collect(Collectors.toList());
        }
    }

    @NonNullApi
    @Deprecated
    public static class ClassSourceGroovyCallInterceptorsProvider
    implements GroovyCallInterceptorsProvider {
        private final Lazy<List<CallInterceptor>> interceptors = Lazy.locking().of(() -> ClassSourceGroovyCallInterceptorsProvider.getInterceptorsFromClass(className));

        public ClassSourceGroovyCallInterceptorsProvider(String className) {
        }

        @Override
        public List<CallInterceptor> getCallInterceptors() {
            return (List)this.interceptors.get();
        }

        private static List<CallInterceptor> getInterceptorsFromClass(String className) {
            try {
                return ClassSourceGroovyCallInterceptorsProvider.getInterceptorsFromClass(Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        private static List<CallInterceptor> getInterceptorsFromClass(Class<?> interceptorsProviderClass) {
            Method getCallInterceptors;
            try {
                getCallInterceptors = interceptorsProviderClass.getDeclaredMethod("getCallInterceptors", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("The provider class does not have the expected getCallInterceptors method", e);
            }
            try {
                return ImmutableList.copyOf((Collection)((List)Cast.uncheckedNonnullCast((Object)getCallInterceptors.invoke(null, new Object[0]))));
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Cannot access the getCallInterceptors method in the provider class", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @NonNullApi
    public static class ClassLoaderSourceGroovyCallInterceptorsProvider
    implements GroovyCallInterceptorsProvider {
        private final Lazy<List<CallInterceptor>> interceptors = Lazy.locking().of(() -> ClassLoaderSourceGroovyCallInterceptorsProvider.getInterceptorsFromClassLoader(classLoader, forPackage));

        public ClassLoaderSourceGroovyCallInterceptorsProvider(ClassLoader classLoader) {
            this(classLoader, "");
        }

        @VisibleForTesting
        public ClassLoaderSourceGroovyCallInterceptorsProvider(ClassLoader classLoader, String forPackage) {
        }

        private static List<CallInterceptor> getInterceptorsFromClassLoader(ClassLoader classLoader, String forPackage) {
            ImmutableList.Builder interceptors = ImmutableList.builder();
            for (CallInterceptor interceptor : ServiceLoader.load(CallInterceptor.class, classLoader)) {
                if (!interceptor.getClass().getPackage().getName().startsWith(forPackage)) continue;
                interceptors.add((Object)interceptor);
            }
            return interceptors.build();
        }

        @Override
        public List<CallInterceptor> getCallInterceptors() {
            return (List)this.interceptors.get();
        }
    }
}

