/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.jvm.internal;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationPublications;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.capabilities.CapabilitiesMetadata;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRolesForMigration;
import org.gradle.api.internal.artifacts.configurations.RoleBasedConfigurationContainerInternal;
import org.gradle.api.internal.artifacts.dsl.LazyPublishArtifact;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.DefaultSourceSet;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.internal.JvmPluginsHelper;
import org.gradle.api.plugins.jvm.internal.JvmFeatureInternal;
import org.gradle.api.plugins.jvm.internal.JvmLanguageUtilities;
import org.gradle.api.plugins.jvm.internal.JvmPluginServices;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.util.internal.TextUtil;

public class DefaultJvmFeature
implements JvmFeatureInternal {
    private final String name;
    private final SourceSet sourceSet;
    private final List<Capability> capabilities;
    private final boolean extendProductionCode;
    private final ProjectInternal project;
    private final JvmPluginServices jvmPluginServices;
    private final JvmLanguageUtilities jvmLanguageUtilities;
    private final TaskProvider<Jar> jar;
    private final TaskProvider<JavaCompile> compileJava;
    private final Configuration implementation;
    private final Configuration runtimeOnly;
    private final Configuration compileOnly;
    private Configuration compileOnlyApi;
    private Configuration api;
    private final Configuration runtimeClasspath;
    private final Configuration compileClasspath;
    private final Configuration apiElements;
    private final Configuration runtimeElements;
    private Configuration javadocElements;
    private Configuration sourcesElements;

    public DefaultJvmFeature(String name, SourceSet sourceSet, List<Capability> capabilities, ProjectInternal project, boolean useMigrationRoleForElementsConfigurations, boolean extendProductionCode) {
        this.name = name;
        this.sourceSet = sourceSet;
        this.capabilities = capabilities;
        this.project = project;
        this.extendProductionCode = extendProductionCode;
        if (extendProductionCode && !SourceSet.isMain((SourceSet)sourceSet)) {
            throw new GradleException("Cannot extend main feature if source set is not also main.");
        }
        this.jvmPluginServices = (JvmPluginServices)project.getServices().get(JvmPluginServices.class);
        this.jvmLanguageUtilities = (JvmLanguageUtilities)project.getServices().get(JvmLanguageUtilities.class);
        RoleBasedConfigurationContainerInternal configurations = project.getConfigurations();
        TaskContainerInternal tasks = project.getTasks();
        this.compileJava = tasks.named(sourceSet.getCompileJavaTaskName(), JavaCompile.class);
        this.jar = this.registerOrGetJarTask(sourceSet, (TaskContainer)tasks);
        this.implementation = this.dependencyScope("Implementation", "implementation", extendProductionCode, false);
        this.compileOnly = this.dependencyScope("Compile-only", "compileOnly", extendProductionCode, false);
        this.runtimeOnly = this.dependencyScope("Runtime-only", "runtimeOnly", extendProductionCode, false);
        this.runtimeClasspath = configurations.getByName(sourceSet.getRuntimeClasspathConfigurationName());
        this.compileClasspath = configurations.getByName(sourceSet.getCompileClasspathConfigurationName());
        LazyPublishArtifact jarArtifact = new LazyPublishArtifact(this.jar, project.getFileResolver(), project.getTaskDependencyFactory());
        this.apiElements = this.createApiElements(configurations, (PublishArtifact)jarArtifact, this.compileJava, useMigrationRoleForElementsConfigurations);
        this.runtimeElements = this.createRuntimeElements(configurations, (PublishArtifact)jarArtifact, this.compileJava, useMigrationRoleForElementsConfigurations);
        if (extendProductionCode) {
            this.doExtendProductionCode();
        }
        JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().findByType(JavaPluginExtension.class);
        JvmPluginsHelper.configureJavaDocTask("'" + name + "' feature", sourceSet, (TaskContainer)tasks, javaPluginExtension);
    }

    void doExtendProductionCode() {
        RoleBasedConfigurationContainerInternal configurations = this.project.getConfigurations();
        SourceSet mainSourceSet = (SourceSet)((JavaPluginExtension)this.project.getExtensions().findByType(JavaPluginExtension.class)).getSourceSets().getByName("main");
        configurations.getByName(mainSourceSet.getCompileClasspathConfigurationName()).extendsFrom(new Configuration[]{this.implementation, this.compileOnly});
        configurations.getByName(mainSourceSet.getRuntimeClasspathConfigurationName()).extendsFrom(new Configuration[]{this.implementation, this.runtimeOnly});
        configurations.getByName("testCompileClasspath").extendsFrom(new Configuration[]{this.implementation});
        configurations.getByName("testRuntimeClasspath").extendsFrom(new Configuration[]{this.implementation, this.runtimeOnly});
    }

    private String getConfigurationName(String suffix) {
        if (this.extendProductionCode) {
            return this.name + StringUtils.capitalize((String)suffix);
        }
        return ((DefaultSourceSet)this.sourceSet).configurationNameOf(suffix);
    }

    private static void addJarArtifactToConfiguration(Configuration configuration, PublishArtifact jarArtifact) {
        ConfigurationPublications publications = configuration.getOutgoing();
        publications.getArtifacts().add((Object)jarArtifact);
        publications.getAttributes().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"jar");
    }

    private Configuration createApiElements(RoleBasedConfigurationContainerInternal configurations, PublishArtifact jarArtifact, TaskProvider<JavaCompile> compileJava, boolean useMigrationRoleForElementsConfigurations) {
        String configName = this.getConfigurationName("apiElements");
        Configuration apiElements = DefaultJvmFeature.maybeCreateElementsConfiguration(configName, configurations, useMigrationRoleForElementsConfigurations);
        apiElements.setVisible(false);
        this.jvmLanguageUtilities.useDefaultTargetPlatformInference(apiElements, compileJava);
        this.jvmPluginServices.configureAsApiElements((HasConfigurableAttributes)apiElements);
        this.capabilities.forEach(arg_0 -> ((ConfigurationPublications)apiElements.getOutgoing()).capability(arg_0));
        apiElements.setDescription("API elements for the '" + this.name + "' feature.");
        DefaultJvmFeature.addJarArtifactToConfiguration(apiElements, jarArtifact);
        return apiElements;
    }

    private Configuration createRuntimeElements(RoleBasedConfigurationContainerInternal configurations, PublishArtifact jarArtifact, TaskProvider<JavaCompile> compileJava, boolean useMigrationRoleForElementsConfigurations) {
        String configName = this.getConfigurationName("runtimeElements");
        Configuration runtimeElements = DefaultJvmFeature.maybeCreateElementsConfiguration(configName, configurations, useMigrationRoleForElementsConfigurations);
        runtimeElements.setVisible(false);
        this.jvmLanguageUtilities.useDefaultTargetPlatformInference(runtimeElements, compileJava);
        this.jvmPluginServices.configureAsRuntimeElements((HasConfigurableAttributes)runtimeElements);
        this.capabilities.forEach(arg_0 -> ((ConfigurationPublications)runtimeElements.getOutgoing()).capability(arg_0));
        runtimeElements.setDescription("Runtime elements for the '" + this.name + "' feature.");
        runtimeElements.extendsFrom(new Configuration[]{this.implementation, this.runtimeOnly});
        DefaultJvmFeature.addJarArtifactToConfiguration(runtimeElements, jarArtifact);
        this.jvmPluginServices.configureClassesDirectoryVariant(runtimeElements, this.sourceSet);
        this.jvmPluginServices.configureResourcesDirectoryVariant(runtimeElements, this.sourceSet);
        return runtimeElements;
    }

    private static Configuration maybeCreateElementsConfiguration(String name, RoleBasedConfigurationContainerInternal configurations, boolean useMigrationRoleForElementsConfigurations) {
        if (useMigrationRoleForElementsConfigurations) {
            return configurations.maybeCreateMigratingUnlocked(name, ConfigurationRolesForMigration.CONSUMABLE_DEPENDENCY_SCOPE_TO_CONSUMABLE);
        }
        return configurations.maybeCreateConsumableUnlocked(name);
    }

    @Override
    public void withApi() {
        this.api = this.dependencyScope("API", "api", true, false);
        this.compileOnlyApi = this.dependencyScope("Compile-only API", "compileOnlyApi", true, true);
        this.apiElements.extendsFrom(new Configuration[]{this.api, this.compileOnlyApi});
        this.implementation.extendsFrom(new Configuration[]{this.api});
        this.compileOnly.extendsFrom(new Configuration[]{this.compileOnlyApi});
        this.jvmPluginServices.configureClassesDirectoryVariant(this.apiElements, this.sourceSet);
        if (this.extendProductionCode) {
            this.project.getConfigurations().getByName("testCompileClasspath").extendsFrom(new Configuration[]{this.compileOnlyApi});
        }
    }

    @Override
    public void withJavadocJar() {
        if (this.javadocElements != null) {
            return;
        }
        this.javadocElements = JvmPluginsHelper.createDocumentationVariantWithArtifact(this.sourceSet.getJavadocElementsConfigurationName(), SourceSet.isMain((SourceSet)this.sourceSet) ? null : this.name, "javadoc", this.capabilities, this.sourceSet.getJavadocJarTaskName(), this.project.getTasks().named(this.sourceSet.getJavadocTaskName()), this.project);
    }

    @Override
    public void withSourcesJar() {
        if (this.sourcesElements != null) {
            return;
        }
        this.sourcesElements = JvmPluginsHelper.createDocumentationVariantWithArtifact(this.sourceSet.getSourcesElementsConfigurationName(), SourceSet.isMain((SourceSet)this.sourceSet) ? null : this.name, "sources", this.capabilities, this.sourceSet.getSourcesJarTaskName(), this.sourceSet.getAllSource(), this.project);
    }

    private Configuration dependencyScope(String kind, String suffix, boolean create, boolean warnOnDuplicate) {
        String configName = this.getConfigurationName(suffix);
        Configuration configuration = create ? this.project.getConfigurations().maybeCreateDependencyScopeUnlocked(configName, warnOnDuplicate) : this.project.getConfigurations().getByName(configName);
        configuration.setDescription(kind + " dependencies for the '" + this.name + "' feature.");
        configuration.setVisible(false);
        return configuration;
    }

    private TaskProvider<Jar> registerOrGetJarTask(SourceSet sourceSet, TaskContainer tasks) {
        String jarTaskName = sourceSet.getJarTaskName();
        if (!tasks.getNames().contains(jarTaskName)) {
            return tasks.register(jarTaskName, Jar.class, jar -> {
                jar.setDescription("Assembles a jar archive containing the classes of the '" + this.name + "' feature.");
                jar.setGroup("build");
                jar.from(new Object[]{sourceSet.getOutput()});
                if (!this.capabilities.isEmpty()) {
                    jar.getArchiveClassifier().set((Object)TextUtil.camelToKebabCase((String)this.name));
                }
            });
        }
        return tasks.named(jarTaskName, Jar.class);
    }

    @Override
    public CapabilitiesMetadata getCapabilities() {
        return ImmutableCapabilities.of(this.capabilities);
    }

    @Override
    public TaskProvider<Jar> getJarTask() {
        return this.jar;
    }

    @Override
    public TaskProvider<JavaCompile> getCompileJavaTask() {
        return this.compileJava;
    }

    @Override
    public SourceSet getSourceSet() {
        return this.sourceSet;
    }

    @Override
    public Configuration getImplementationConfiguration() {
        return this.implementation;
    }

    @Override
    public Configuration getRuntimeOnlyConfiguration() {
        return this.runtimeOnly;
    }

    @Override
    public Configuration getCompileOnlyConfiguration() {
        return this.compileOnly;
    }

    @Override
    public Configuration getApiConfiguration() {
        return this.api;
    }

    @Override
    public Configuration getCompileOnlyApiConfiguration() {
        return this.compileOnlyApi;
    }

    @Override
    public Configuration getRuntimeClasspathConfiguration() {
        return this.runtimeClasspath;
    }

    @Override
    public Configuration getCompileClasspathConfiguration() {
        return this.compileClasspath;
    }

    @Override
    public Configuration getApiElementsConfiguration() {
        return this.apiElements;
    }

    @Override
    public Configuration getRuntimeElementsConfiguration() {
        return this.runtimeElements;
    }

    @Override
    public Configuration getJavadocElementsConfiguration() {
        return this.javadocElements;
    }

    @Override
    public Configuration getSourcesElementsConfiguration() {
        return this.sourcesElements;
    }
}

