/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.linkage.issues;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.linkage.issues.UnexpectedUnboundIrSymbols;
import org.jetbrains.kotlin.backend.common.serialization.KotlinIrLinker;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IrMessageLogger;
import org.jetbrains.kotlin.ir.util.IrMessageLoggerKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.ir.util.SymbolTableKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\t"}, d2={"checkNoUnboundSymbols", "", "Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "whenDetected", "", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "Lorg/jetbrains/kotlin/ir/util/IrMessageLogger;", "ir.serialization.common"})
public final class ChecksKt {
    public static final void checkNoUnboundSymbols(@NotNull KotlinIrLinker $this$checkNoUnboundSymbols, @NotNull SymbolTable symbolTable, @NotNull String whenDetected) {
        Intrinsics.checkNotNullParameter((Object)$this$checkNoUnboundSymbols, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        Intrinsics.checkNotNullParameter((Object)whenDetected, (String)"whenDetected");
        ChecksKt.checkNoUnboundSymbols($this$checkNoUnboundSymbols.getMessageLogger(), symbolTable, whenDetected);
    }

    public static final void checkNoUnboundSymbols(@NotNull IrMessageLogger $this$checkNoUnboundSymbols, @NotNull SymbolTable symbolTable, @NotNull String whenDetected) {
        Intrinsics.checkNotNullParameter((Object)$this$checkNoUnboundSymbols, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        Intrinsics.checkNotNullParameter((Object)whenDetected, (String)"whenDetected");
        Set<IrSymbol> unboundSymbols = SymbolTableKt.getAllUnbound(symbolTable);
        if (!((Collection)unboundSymbols).isEmpty()) {
            new UnexpectedUnboundIrSymbols(unboundSymbols, whenDetected).raiseIssue($this$checkNoUnboundSymbols);
            throw null;
        }
    }

    public static final void checkNoUnboundSymbols(@NotNull CompilerConfiguration $this$checkNoUnboundSymbols, @NotNull SymbolTable symbolTable, @NotNull String whenDetected) {
        Intrinsics.checkNotNullParameter((Object)$this$checkNoUnboundSymbols, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        Intrinsics.checkNotNullParameter((Object)whenDetected, (String)"whenDetected");
        Set<IrSymbol> unboundSymbols = SymbolTableKt.getAllUnbound(symbolTable);
        if (!((Collection)unboundSymbols).isEmpty()) {
            new UnexpectedUnboundIrSymbols(unboundSymbols, whenDetected).raiseIssue(IrMessageLoggerKt.getIrMessageLogger($this$checkNoUnboundSymbols));
            throw null;
        }
    }
}

