/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.application.impl;

import java.awt.Dialog;
import java.awt.Window;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.diagnostic.LoadingState;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.ModalityState;
import org.jetbrains.kotlin.com.intellij.openapi.application.ModalityStateListener;
import org.jetbrains.kotlin.com.intellij.openapi.application.TransactionGuard;
import org.jetbrains.kotlin.com.intellij.openapi.application.TransactionGuardImpl;
import org.jetbrains.kotlin.com.intellij.openapi.application.ex.ApplicationManagerEx;
import org.jetbrains.kotlin.com.intellij.openapi.application.impl.FlushQueue;
import org.jetbrains.kotlin.com.intellij.openapi.application.impl.ModalityStateEx;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.util.EventDispatcher;
import org.jetbrains.kotlin.com.intellij.util.concurrency.AppExecutorUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.CollectionFactory;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.Stack;
import org.jetbrains.kotlin.com.intellij.util.ui.EDT;

public final class LaterInvocator {
    private static final Logger LOG = Logger.getInstance(LaterInvocator.class);
    private static final List<Object> ourModalEntities = ContainerUtil.createLockFreeCopyOnWriteList();
    private static final Map<Project, List<Dialog>> projectToModalEntities = ContainerUtil.createWeakMap();
    private static final Map<Project, Stack<ModalityState>> projectToModalEntitiesStack = ContainerUtil.createWeakMap();
    private static final Stack<ModalityStateEx> ourModalityStack = new Stack<ModalityStateEx>((ModalityStateEx)ModalityState.NON_MODAL);
    private static final EventDispatcher<ModalityStateListener> ourModalityStateMulticaster = EventDispatcher.create(ModalityStateListener.class);
    private static final Executor ourWriteThreadExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor("Write Thread", 1);
    private static final FlushQueue ourEdtQueue = new FlushQueue(SwingUtilities::invokeLater);
    private static final FlushQueue ourWtQueue = new FlushQueue(r -> ourWriteThreadExecutor.execute(() -> ApplicationManagerEx.getApplicationEx().runIntendedWriteActionOnCurrentThread((Runnable)r)));
    private static final ConcurrentMap<Window, ModalityStateEx> ourWindowModalities = CollectionFactory.createConcurrentWeakMap();
    static final AtomicBoolean FLUSHER_SCHEDULED = new AtomicBoolean(false);
    private static final AtomicLong SUBMITTED_COUNT = new AtomicLong(0L);
    private static final AtomicInteger THREAD_TO_FLUSH = new AtomicInteger(0);

    private LaterInvocator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enterModal(@NotNull Object modalEntity, @NotNull ModalityStateEx appendedState) {
        TransactionGuardImpl guard;
        if (modalEntity == null) {
            LaterInvocator.$$$reportNull$$$0(19);
        }
        if (appendedState == null) {
            LaterInvocator.$$$reportNull$$$0(20);
        }
        LOG.assertTrue(LaterInvocator.isWriteThread(), "enterModal() should be invoked in write thread");
        if (LOG.isDebugEnabled()) {
            LOG.debug("enterModal:" + modalEntity);
        }
        ourModalityStateMulticaster.getMulticaster().beforeModalityStateChanged(true, modalEntity);
        ourModalEntities.add(modalEntity);
        Stack<ModalityStateEx> stack = ourModalityStack;
        synchronized (stack) {
            ourModalityStack.push(appendedState);
        }
        TransactionGuardImpl transactionGuardImpl = guard = LoadingState.COMPONENTS_LOADED.isOccurred() ? (TransactionGuardImpl)TransactionGuard.getInstance() : null;
        if (guard != null) {
            guard.enteredModality(appendedState);
        }
        LaterInvocator.reincludeSkippedItemsAndRequestFlush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeModality(@NotNull Object modalEntity, int index2) {
        if (modalEntity == null) {
            LaterInvocator.$$$reportNull$$$0(24);
        }
        ourModalEntities.remove(index2);
        Stack<ModalityStateEx> stack = ourModalityStack;
        synchronized (stack) {
            ourModalityStack.remove(index2 + 1);
            for (int i = 1; i < ourModalityStack.size(); ++i) {
                ((ModalityStateEx)ourModalityStack.get(i)).removeModality(modalEntity);
            }
        }
        ModalityStateEx.unmarkTransparent(modalEntity);
    }

    public static void leaveModal(@NotNull Object modalEntity) {
        if (modalEntity == null) {
            LaterInvocator.$$$reportNull$$$0(25);
        }
        LOG.assertTrue(LaterInvocator.isWriteThread(), "leaveModal() should be invoked in write thread");
        if (LOG.isDebugEnabled()) {
            LOG.debug("leaveModal:" + modalEntity);
        }
        ourModalityStateMulticaster.getMulticaster().beforeModalityStateChanged(false, modalEntity);
        int index2 = ourModalEntities.indexOf(modalEntity);
        LOG.assertTrue(index2 >= 0);
        LaterInvocator.removeModality(modalEntity, index2);
        LaterInvocator.reincludeSkippedItemsAndRequestFlush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static ModalityStateEx getCurrentModalityState() {
        if (!EDT.isCurrentThreadEdt()) {
            ApplicationManager.getApplication().assertIsWriteThread();
        }
        Stack<ModalityStateEx> stack = ourModalityStack;
        // MONITORENTER : stack
        ModalityStateEx modalityStateEx = ourModalityStack.peek();
        // MONITOREXIT : stack
        if (modalityStateEx != null) return modalityStateEx;
        LaterInvocator.$$$reportNull$$$0(27);
        return modalityStateEx;
    }

    private static boolean isWriteThread() {
        return ApplicationManager.getApplication().isWriteThread();
    }

    @NotNull
    private static FlushQueue getRunnableQueue(boolean onEdt) {
        FlushQueue flushQueue = onEdt ? ourEdtQueue : ourWtQueue;
        if (flushQueue == null) {
            LaterInvocator.$$$reportNull$$$0(28);
        }
        return flushQueue;
    }

    static void requestFlush() {
        SUBMITTED_COUNT.incrementAndGet();
        while (FLUSHER_SCHEDULED.compareAndSet(false, true)) {
            int whichThread = THREAD_TO_FLUSH.getAndUpdate(operand -> operand ^ 1);
            long submittedCount = SUBMITTED_COUNT.get();
            FlushQueue firstQueue = LaterInvocator.getRunnableQueue(whichThread == 0);
            if (firstQueue.mayHaveItems()) {
                firstQueue.scheduleFlush();
                return;
            }
            FlushQueue secondQueue = LaterInvocator.getRunnableQueue(whichThread != 0);
            if (secondQueue.mayHaveItems()) {
                secondQueue.scheduleFlush();
                return;
            }
            FLUSHER_SCHEDULED.set(false);
            if (submittedCount != SUBMITTED_COUNT.get()) continue;
            break;
        }
    }

    public static void pollWriteThreadEventsOnce() {
        LOG.assertTrue(!SwingUtilities.isEventDispatchThread());
        LOG.assertTrue(ApplicationManager.getApplication().isWriteThread());
        ourWtQueue.flushNow();
    }

    private static void reincludeSkippedItemsAndRequestFlush() {
        ourEdtQueue.reincludeSkippedItems();
        ourWtQueue.reincludeSkippedItems();
        LaterInvocator.requestFlush();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 12: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 12: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 3: 
            case 12: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/application/impl/LaterInvocator";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 6: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expired";
                break;
            }
            case 8: 
            case 10: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 18: 
            case 19: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalEntity";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appendedState";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialog";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/application/impl/LaterInvocator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "modalityStateForWindow";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeLater";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentModalEntities";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentModalityState";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunnableQueue";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getLaterInvocatorEdtQueue";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getLaterInvocatorWtQueue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addModalityStateListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "modalityStateForWindow";
                break;
            }
            case 3: 
            case 12: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isModalDialog";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "invokeLater";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "invokeLaterWithCallback";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "invokeAndWait";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "enterModal";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "markTransparent";
                break;
            }
            case 23: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "leaveModal";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "removeModality";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 12: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

