/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util;

import java.util.List;
import org.jetbrains.annotations.NonNls;

class ExecutionCallback {
    private int myCurrentCount;
    private final int myCountToExecution;
    private List<Runnable> myRunnables;

    ExecutionCallback() {
        this(1);
    }

    ExecutionCallback(int executedCount) {
        this.myCountToExecution = executedCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setExecuted() {
        List<Runnable> all2;
        if (!this.signalExecution()) {
            return false;
        }
        ExecutionCallback executionCallback = this;
        synchronized (executionCallback) {
            if (this.myRunnables == null) {
                return true;
            }
            all2 = this.myRunnables;
            this.myRunnables = null;
        }
        for (Runnable each : all2) {
            each.run();
        }
        return true;
    }

    synchronized void clear() {
        this.myRunnables = null;
    }

    private synchronized boolean signalExecution() {
        return ++this.myCurrentCount >= this.myCountToExecution;
    }

    @NonNls
    public synchronized String toString() {
        return "current=" + this.myCurrentCount + " countToExecution=" + this.myCountToExecution;
    }
}

