/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.compiled;

import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameHelper;
import org.jetbrains.kotlin.com.intellij.psi.impl.cache.TypeAnnotationContainer;
import org.jetbrains.kotlin.com.intellij.psi.impl.cache.TypeInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.AnnotationTextCollector;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.FirstPassData;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.TypePath;

class ClsTypeAnnotationCollector
extends TypeAnnotationContainer.Collector {
    @NotNull
    private final FirstPassData myFirstPassData;

    ClsTypeAnnotationCollector(@NotNull TypeInfo info, @NotNull FirstPassData classInfo2) {
        if (info == null) {
            ClsTypeAnnotationCollector.$$$reportNull$$$0(0);
        }
        if (classInfo2 == null) {
            ClsTypeAnnotationCollector.$$$reportNull$$$0(1);
        }
        super(info);
        this.myFirstPassData = classInfo2;
    }

    void add(TypePath path2, String text2) {
        byte[] translated = this.translatePath(path2);
        if (translated != null) {
            this.add(translated, text2);
        }
    }

    AnnotationVisitor collect(@Nullable TypePath path2, @Nullable String desc) {
        return new AnnotationTextCollector(desc, this.myFirstPassData, text2 -> this.add(path2, (String)text2));
    }

    private byte[] translatePath(@Nullable TypePath path2) {
        String typeText = this.myTypeInfo.text;
        int arrayLevel = this.myTypeInfo.arrayCount + (this.myTypeInfo.isEllipsis ? (byte)1 : 0);
        String qualifiedName = PsiNameHelper.getQualifiedClassName(typeText, false);
        int depth = this.myFirstPassData.getInnerDepth(qualifiedName);
        boolean atWildcard = false;
        if (path2 == null) {
            if (depth == 0 || arrayLevel > 0) {
                return ArrayUtil.EMPTY_BYTE_ARRAY;
            }
            byte[] result2 = new byte[depth];
            Arrays.fill(result2, (byte)1);
            return result2;
        }
        ByteArrayOutputStream result3 = new ByteArrayOutputStream();
        int length = path2.getLength();
        block6: for (int i = 0; i < length; ++i) {
            byte step = (byte)path2.getStep(i);
            switch (step) {
                case 1: {
                    if (depth == 0) {
                        return null;
                    }
                    --depth;
                    continue block6;
                }
                case 0: {
                    if (arrayLevel <= 0 || atWildcard) {
                        return null;
                    }
                    --arrayLevel;
                    result3.write(0);
                    continue block6;
                }
                case 2: {
                    if (!atWildcard) {
                        return null;
                    }
                    atWildcard = false;
                    result3.write(2);
                    continue block6;
                }
                case 3: {
                    String[] arguments2;
                    if (atWildcard || arrayLevel > 0) {
                        return null;
                    }
                    while (depth-- > 0) {
                        result3.write(1);
                        typeText = PsiNameHelper.getOuterClassReference(typeText);
                    }
                    int argumentIndex = path2.getStepArgument(i);
                    if (argumentIndex >= (arguments2 = PsiNameHelper.getClassParametersText(typeText)).length) {
                        return null;
                    }
                    TypeInfo argument2 = TypeInfo.fromString(arguments2[argumentIndex], false);
                    arrayLevel = argument2.arrayCount;
                    typeText = argument2.text;
                    if (typeText.startsWith("? extends ")) {
                        typeText = typeText.substring("? extends ".length());
                        atWildcard = true;
                    } else if (typeText.startsWith("? super ")) {
                        typeText = typeText.substring("? super ".length());
                        atWildcard = true;
                    }
                    qualifiedName = PsiNameHelper.getQualifiedClassName(typeText, false);
                    depth = this.myFirstPassData.getInnerDepth(qualifiedName);
                    result3.write(3);
                    result3.write(argumentIndex);
                }
            }
        }
        if (!atWildcard && arrayLevel == 0) {
            while (depth-- > 0) {
                result3.write(1);
            }
        }
        return result3.toByteArray();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "info";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "classInfo";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsTypeAnnotationCollector";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

