/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.resolve.calls.inference.NewConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.components.NewTypeSubstitutor;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintSystemError;
import org.jetbrains.kotlin.resolve.calls.inference.model.NewConstraintError;
import org.jetbrains.kotlin.resolve.calls.inference.model.NewConstraintMismatch;
import org.jetbrains.kotlin.resolve.calls.inference.model.NewConstraintWarning;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnosticsKt;
import org.jetbrains.kotlin.resolve.calls.model.KotlinConstraintSystemDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.ResolutionAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallAtom;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B'\b\u0004\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u0004J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u0082\u0001\u0002\u001a\u001b\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/model/CallResolutionResult;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedAtom;", "resultCallAtom", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCallAtom;", "diagnostics", "", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallDiagnostic;", "constraintSystem", "Lorg/jetbrains/kotlin/resolve/calls/inference/NewConstraintSystem;", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCallAtom;Ljava/util/List;Lorg/jetbrains/kotlin/resolve/calls/inference/NewConstraintSystem;)V", "atom", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolutionAtom;", "getAtom", "()Lorg/jetbrains/kotlin/resolve/calls/model/ResolutionAtom;", "getConstraintSystem", "()Lorg/jetbrains/kotlin/resolve/calls/inference/NewConstraintSystem;", "getDiagnostics", "()Ljava/util/List;", "completedDiagnostic", "substitutor", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/NewTypeSubstitutor;", "setAnalyzedResults", "", "subResolvedAtoms", "toString", "", "Lorg/jetbrains/kotlin/resolve/calls/model/AllCandidatesResolutionResult;", "Lorg/jetbrains/kotlin/resolve/calls/model/SingleCallResolutionResult;", "resolution"})
@SourceDebugExtension(value={"SMAP\nResolutionAtoms.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolutionAtoms.kt\norg/jetbrains/kotlin/resolve/calls/model/CallResolutionResult\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,351:1\n1549#2:352\n1620#2,3:353\n*S KotlinDebug\n*F\n+ 1 ResolutionAtoms.kt\norg/jetbrains/kotlin/resolve/calls/model/CallResolutionResult\n*L\n280#1:352\n280#1:353,3\n*E\n"})
public abstract class CallResolutionResult
extends ResolvedAtom {
    @NotNull
    private final List<KotlinCallDiagnostic> diagnostics;
    @NotNull
    private final NewConstraintSystem constraintSystem;

    private CallResolutionResult(ResolvedCallAtom resultCallAtom, List<? extends KotlinCallDiagnostic> diagnostics2, NewConstraintSystem constraintSystem) {
        super(null);
        this.diagnostics = diagnostics2;
        this.constraintSystem = constraintSystem;
        this.setAnalyzedResults(CollectionsKt.listOfNotNull((Object)resultCallAtom));
    }

    @NotNull
    public final List<KotlinCallDiagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    @NotNull
    public final NewConstraintSystem getConstraintSystem() {
        return this.constraintSystem;
    }

    @Override
    protected final void setAnalyzedResults(@NotNull List<? extends ResolvedAtom> subResolvedAtoms) {
        Intrinsics.checkNotNullParameter(subResolvedAtoms, (String)"subResolvedAtoms");
        super.setAnalyzedResults(subResolvedAtoms);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<KotlinCallDiagnostic> completedDiagnostic(@NotNull NewTypeSubstitutor substitutor2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)substitutor2, (String)"substitutor");
        Iterable $this$map$iv = this.diagnostics;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ConstraintSystemError error;
            KotlinCallDiagnostic kotlinCallDiagnostic;
            void it;
            KotlinCallDiagnostic kotlinCallDiagnostic2 = (KotlinCallDiagnostic)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (KotlinCallDiagnosticsKt.getConstraintSystemError((KotlinCallDiagnostic)it) == null) {
                kotlinCallDiagnostic = it;
            } else if (!(error instanceof NewConstraintMismatch)) {
                kotlinCallDiagnostic = it;
            } else {
                Object object = ((NewConstraintMismatch)((Object)error)).getLowerType();
                KotlinType kotlinType = object instanceof KotlinType ? (KotlinType)object : null;
                if (kotlinType == null || (kotlinType = kotlinType.unwrap()) == null) {
                    kotlinCallDiagnostic = it;
                } else {
                    KotlinConstraintSystemDiagnostic kotlinConstraintSystemDiagnostic;
                    KotlinType lowerType = kotlinType;
                    UnwrappedType newLowerType = substitutor2.safeSubstitute(TypeUtilsKt.unCapture((UnwrappedType)lowerType));
                    object = (NewConstraintMismatch)((Object)error);
                    if (object instanceof NewConstraintError) {
                        kotlinConstraintSystemDiagnostic = KotlinCallDiagnosticsKt.asDiagnostic(new NewConstraintError(newLowerType, ((NewConstraintMismatch)((Object)error)).getUpperType(), ((NewConstraintMismatch)((Object)error)).getPosition()));
                    } else if (object instanceof NewConstraintWarning) {
                        kotlinConstraintSystemDiagnostic = KotlinCallDiagnosticsKt.asDiagnostic(new NewConstraintWarning(newLowerType, ((NewConstraintMismatch)((Object)error)).getUpperType(), ((NewConstraintMismatch)((Object)error)).getPosition()));
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    kotlinCallDiagnostic = kotlinConstraintSystemDiagnostic;
                }
            }
            collection.add(kotlinCallDiagnostic);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public ResolutionAtom getAtom() {
        return null;
    }

    @NotNull
    public String toString() {
        return "diagnostics: (" + CollectionsKt.joinToString$default((Iterable)this.diagnostics, null, null, null, (int)0, null, null, (int)63, null) + ')';
    }

    public /* synthetic */ CallResolutionResult(ResolvedCallAtom resultCallAtom, List diagnostics2, NewConstraintSystem constraintSystem, DefaultConstructorMarker $constructor_marker) {
        this(resultCallAtom, diagnostics2, constraintSystem);
    }
}

