/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl.dependencies;

import org.gradle.api.attributes.AttributeCompatibilityRule;
import org.gradle.api.attributes.AttributeDisambiguationRule;
import org.gradle.api.attributes.AttributeMatchingStrategy;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.attributes.CompatibilityCheckDetails;
import org.gradle.api.attributes.MultipleCandidatesDetails;
import org.gradle.api.attributes.plugin.GradlePluginApiVersion;
import org.gradle.util.GradleVersion;

public class GradlePluginVariantsSupport {
    public static void configureSchema(AttributesSchema attributesSchema) {
        AttributeMatchingStrategy strategy = attributesSchema.attribute(GradlePluginApiVersion.GRADLE_PLUGIN_API_VERSION_ATTRIBUTE);
        strategy.getCompatibilityRules().add(TargetGradleVersionCompatibilityRule.class);
        strategy.getDisambiguationRules().add(TargetGradleVersionDisambiguationRule.class);
    }

    public static class TargetGradleVersionDisambiguationRule
    implements AttributeDisambiguationRule<GradlePluginApiVersion> {
        public void execute(MultipleCandidatesDetails<GradlePluginApiVersion> details) {
            GradlePluginApiVersion consumerValue = (GradlePluginApiVersion)details.getConsumerValue();
            GradleVersion consumer = consumerValue == null ? GradleVersion.current() : GradleVersion.version((String)consumerValue.getName());
            GradleVersion bestMatchVersion = GradleVersion.version((String)"0.0");
            GradlePluginApiVersion bestMatchAttribute = null;
            for (GradlePluginApiVersion candidate : details.getCandidateValues()) {
                GradleVersion producer = GradleVersion.version((String)candidate.getName());
                if (producer.compareTo(consumer) > 0 || producer.compareTo(bestMatchVersion) <= 0) continue;
                bestMatchVersion = producer;
                bestMatchAttribute = candidate;
            }
            if (bestMatchAttribute != null) {
                details.closestMatch(bestMatchAttribute);
            }
        }
    }

    public static class TargetGradleVersionCompatibilityRule
    implements AttributeCompatibilityRule<GradlePluginApiVersion> {
        public void execute(CompatibilityCheckDetails<GradlePluginApiVersion> details) {
            GradlePluginApiVersion consumer = (GradlePluginApiVersion)details.getConsumerValue();
            GradlePluginApiVersion producer = (GradlePluginApiVersion)details.getProducerValue();
            if (consumer == null || producer == null) {
                details.compatible();
            } else if (GradleVersion.version((String)consumer.getName()).getBaseVersion().compareTo(GradleVersion.version((String)producer.getName())) >= 0) {
                details.compatible();
            } else {
                details.incompatible();
            }
        }
    }
}

