/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy;

import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.ExactVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.InverseVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.LatestVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.SubVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionRangeSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;

public class DefaultVersionSelectorScheme
implements VersionSelectorScheme {
    private final VersionComparator versionComparator;
    private final VersionParser versionParser;

    public DefaultVersionSelectorScheme(VersionComparator versionComparator, VersionParser versionParser) {
        this.versionComparator = versionComparator;
        this.versionParser = versionParser;
    }

    @Override
    public VersionSelector parseSelector(String selectorString) {
        if (VersionRangeSelector.ALL_RANGE.matcher(selectorString).matches()) {
            return this.maybeCreateRangeSelector(selectorString);
        }
        if (DefaultVersionSelectorScheme.isSubVersion(selectorString)) {
            return new SubVersionSelector(selectorString);
        }
        if (DefaultVersionSelectorScheme.isLatestVersion(selectorString)) {
            return new LatestVersionSelector(selectorString);
        }
        return new ExactVersionSelector(selectorString);
    }

    private VersionSelector maybeCreateRangeSelector(String selectorString) {
        VersionRangeSelector rangeSelector = new VersionRangeSelector(selectorString, this.versionComparator.asVersionComparator(), this.versionParser);
        if (DefaultVersionSelectorScheme.isSingleVersionRange(rangeSelector)) {
            return new ExactVersionSelector(rangeSelector.getUpperBound());
        }
        return rangeSelector;
    }

    private static boolean isSingleVersionRange(VersionRangeSelector rangeSelector) {
        String lowerBound = rangeSelector.getLowerBound();
        return lowerBound != null && lowerBound.equals(rangeSelector.getUpperBound()) && rangeSelector.isLowerInclusive() && rangeSelector.isUpperInclusive();
    }

    @Override
    public String renderSelector(VersionSelector selector) {
        return selector.getSelector();
    }

    @Override
    public VersionSelector complementForRejection(VersionSelector selector) {
        return new InverseVersionSelector(selector);
    }

    public static boolean isSubVersion(String selectorString) {
        return selectorString.endsWith("+");
    }

    public static boolean isLatestVersion(String selectorString) {
        return selectorString.startsWith("latest.");
    }
}

