/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.moduleconverter;

import java.lang.ref.SoftReference;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.component.ComponentIdentifierFactory;
import org.gradle.api.internal.artifacts.configurations.ConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.configurations.MutationValidator;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.RootComponentMetadataBuilder;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.LocalConfigurationMetadataBuilder;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.EmptySchema;
import org.gradle.api.internal.initialization.RootScriptDomainObjectContext;
import org.gradle.api.internal.project.HoldsProjectState;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.internal.FinalizableValue;
import org.gradle.internal.component.local.model.DefaultLocalComponentMetadata;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveStateFactory;
import org.gradle.internal.component.model.ConfigurationGraphResolveState;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.model.ModelContainer;

public class DefaultRootComponentMetadataBuilder
implements RootComponentMetadataBuilder,
HoldsProjectState {
    private final DependencyMetaDataProvider metadataProvider;
    private final ComponentIdentifierFactory componentIdentifierFactory;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final LocalConfigurationMetadataBuilder configurationMetadataBuilder;
    private final ConfigurationsProvider configurationsProvider;
    private final MetadataHolder holder;
    private final ProjectStateRegistry projectStateRegistry;
    private final LocalComponentGraphResolveStateFactory localResolveStateFactory;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private final Factory factory;

    private DefaultRootComponentMetadataBuilder(DependencyMetaDataProvider metadataProvider, ComponentIdentifierFactory componentIdentifierFactory, ImmutableModuleIdentifierFactory moduleIdentifierFactory, LocalConfigurationMetadataBuilder configurationMetadataBuilder, ConfigurationsProvider configurationsProvider, ProjectStateRegistry projectStateRegistry, LocalComponentGraphResolveStateFactory localResolveStateFactory, CalculatedValueContainerFactory calculatedValueContainerFactory, Factory factory) {
        this.metadataProvider = metadataProvider;
        this.componentIdentifierFactory = componentIdentifierFactory;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.configurationMetadataBuilder = configurationMetadataBuilder;
        this.configurationsProvider = configurationsProvider;
        this.projectStateRegistry = projectStateRegistry;
        this.localResolveStateFactory = localResolveStateFactory;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
        this.factory = factory;
        this.holder = new MetadataHolder();
    }

    @Override
    public RootComponentMetadataBuilder.RootComponentState toRootComponent(final String configurationName) {
        ComponentIdentifier componentIdentifier;
        Module module = this.metadataProvider.getModule();
        final LocalComponentGraphResolveState state = this.getComponentState(module, componentIdentifier = this.componentIdentifierFactory.createComponentIdentifier(module));
        ConfigurationGraphResolveState configuration = state.getConfiguration(configurationName);
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Expected configuration '%s' to be present in %s", configurationName, componentIdentifier));
        }
        final VariantGraphResolveState rootVariant = configuration.asVariant();
        return new RootComponentMetadataBuilder.RootComponentState(){

            @Override
            public LocalComponentGraphResolveState getRootComponent() {
                return state;
            }

            @Override
            public String getRootConfigurationName() {
                return configurationName;
            }

            @Override
            public VariantGraphResolveState getRootVariant() {
                return rootVariant;
            }
        };
    }

    private LocalComponentGraphResolveState getComponentState(Module module, ComponentIdentifier componentIdentifier) {
        LocalComponentGraphResolveState state = this.holder.tryCached(componentIdentifier);
        if (state == null) {
            state = this.createComponentState(module, componentIdentifier);
            this.holder.cache(state, this.shouldCacheResolutionState());
        }
        return state;
    }

    private LocalComponentGraphResolveState createComponentState(Module module, ComponentIdentifier componentIdentifier) {
        ProjectComponentIdentifier projectId = module.getProjectId();
        if (projectId != null) {
            ProjectState projectState = this.projectStateRegistry.stateFor(projectId);
            if (!projectState.hasMutableState()) {
                throw new IllegalStateException("Thread should hold project lock for " + projectState.getDisplayName());
            }
            return (LocalComponentGraphResolveState)projectState.fromMutableState(project -> {
                LocalComponentGraphResolveState state = this.createProjectRootComponentMetadata((ProjectInternal)project, module, componentIdentifier);
                this.configurationsProvider.visitAll(FinalizableValue::preventFromFurtherMutation);
                return state;
            });
        }
        return this.createRootComponentMetadata(module, componentIdentifier, EmptySchema.INSTANCE, (ModelContainer<?>)RootScriptDomainObjectContext.INSTANCE);
    }

    private LocalComponentGraphResolveState createProjectRootComponentMetadata(ProjectInternal project, Module module, ComponentIdentifier componentIdentifier) {
        return this.createRootComponentMetadata(module, componentIdentifier, (AttributesSchemaInternal)project.getDependencies().getAttributesSchema(), project.getModel());
    }

    private LocalComponentGraphResolveState createRootComponentMetadata(Module module, ComponentIdentifier componentIdentifier, AttributesSchemaInternal schema, ModelContainer<?> model) {
        ModuleVersionIdentifier moduleVersionIdentifier = this.moduleIdentifierFactory.moduleWithVersion(module.getGroup(), module.getName(), module.getVersion());
        DefaultLocalComponentMetadata.ConfigurationsProviderMetadataFactory configurationMetadataFactory = new DefaultLocalComponentMetadata.ConfigurationsProviderMetadataFactory(this.configurationsProvider, this.configurationMetadataBuilder, model, this.calculatedValueContainerFactory);
        this.configurationsProvider.visitAll(FinalizableValue::preventFromFurtherMutation);
        DefaultLocalComponentMetadata metadata = new DefaultLocalComponentMetadata(moduleVersionIdentifier, componentIdentifier, module.getStatus(), schema, configurationMetadataFactory, null);
        if (this.shouldCacheResolutionState()) {
            return this.localResolveStateFactory.stateFor(metadata);
        }
        return this.localResolveStateFactory.adHocStateFor(metadata);
    }

    private boolean shouldCacheResolutionState() {
        return !this.configurationsProvider.isFixedSize() || this.configurationsProvider.size() > 1;
    }

    @Override
    public RootComponentMetadataBuilder withConfigurationsProvider(ConfigurationsProvider provider) {
        return this.factory.create(provider);
    }

    @Override
    public MutationValidator getValidator() {
        return this.holder;
    }

    public void discardAll() {
        this.holder.discard();
    }

    public static class Factory {
        private final DependencyMetaDataProvider metaDataProvider;
        private final ComponentIdentifierFactory componentIdentifierFactory;
        private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
        private final LocalConfigurationMetadataBuilder configurationMetadataBuilder;
        private final ProjectStateRegistry projectStateRegistry;
        private final LocalComponentGraphResolveStateFactory localResolveStateFactory;
        private final CalculatedValueContainerFactory calculatedValueContainerFactory;

        @Inject
        public Factory(DependencyMetaDataProvider metaDataProvider, ComponentIdentifierFactory componentIdentifierFactory, ImmutableModuleIdentifierFactory moduleIdentifierFactory, LocalConfigurationMetadataBuilder configurationMetadataBuilder, ProjectStateRegistry projectStateRegistry, LocalComponentGraphResolveStateFactory localResolveStateFactory, CalculatedValueContainerFactory calculatedValueContainerFactory) {
            this.metaDataProvider = metaDataProvider;
            this.componentIdentifierFactory = componentIdentifierFactory;
            this.moduleIdentifierFactory = moduleIdentifierFactory;
            this.configurationMetadataBuilder = configurationMetadataBuilder;
            this.projectStateRegistry = projectStateRegistry;
            this.localResolveStateFactory = localResolveStateFactory;
            this.calculatedValueContainerFactory = calculatedValueContainerFactory;
        }

        public RootComponentMetadataBuilder create(ConfigurationsProvider configurationsProvider) {
            return new DefaultRootComponentMetadataBuilder(this.metaDataProvider, this.componentIdentifierFactory, this.moduleIdentifierFactory, this.configurationMetadataBuilder, configurationsProvider, this.projectStateRegistry, this.localResolveStateFactory, this.calculatedValueContainerFactory, this);
        }
    }

    private static class MetadataHolder
    implements MutationValidator {
        @Nullable
        private SoftReference<LocalComponentGraphResolveState> reference;
        @Nullable
        private LocalComponentGraphResolveState cachedValue;

        private MetadataHolder() {
        }

        @Override
        public void validateMutation(MutationValidator.MutationType type) {
            LocalComponentGraphResolveState value;
            if ((type == MutationValidator.MutationType.DEPENDENCIES || type == MutationValidator.MutationType.ARTIFACTS || type == MutationValidator.MutationType.DEPENDENCY_ATTRIBUTES || type == MutationValidator.MutationType.USAGE || type == MutationValidator.MutationType.HIERARCHY) && (value = this.currentValue()) != null) {
                value.reevaluate();
            }
        }

        @Nullable
        LocalComponentGraphResolveState tryCached(ComponentIdentifier id) {
            LocalComponentGraphResolveState value = this.currentValue();
            assert (value == null || value.getId().equals(id));
            return value;
        }

        @Nullable
        private LocalComponentGraphResolveState currentValue() {
            if (this.reference != null) {
                return this.reference.get();
            }
            return this.cachedValue;
        }

        public void discard() {
            this.reference = null;
            this.cachedValue = null;
        }

        public void cache(LocalComponentGraphResolveState state, boolean useStrongReference) {
            if (useStrongReference) {
                this.reference = null;
                this.cachedValue = state;
            } else {
                this.reference = new SoftReference<LocalComponentGraphResolveState>(state);
                this.cachedValue = null;
            }
        }
    }
}

