/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.Conflict;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.GraphValidationException;
import org.gradle.internal.exceptions.ResolutionProvider;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.util.internal.TextUtil;

public class VersionConflictException
extends GraphValidationException
implements ResolutionProvider {
    private static final int MAX_SEEN_MODULE_COUNT = 10;
    private final Collection<Conflict> conflicts;
    private final List<String> resolutions;

    private VersionConflictException(String message, Collection<Conflict> conflicts, List<String> resolutions) {
        super(message);
        this.conflicts = conflicts;
        this.resolutions = resolutions;
    }

    public Collection<Conflict> getConflicts() {
        return this.conflicts;
    }

    private static String buildMessage(Collection<Conflict> conflicts) {
        TreeFormatter formatter = new TreeFormatter();
        String plural = TextUtil.getPluralEnding(conflicts);
        formatter.node("Conflict" + plural + " found for the following module" + plural);
        formatter.startChildren();
        conflicts.stream().limit(10L).forEach(conflict -> formatter.node(conflict.getMessage()));
        if (conflicts.size() > 10) {
            formatter.node("... and more");
        }
        formatter.endChildren();
        return formatter.toString();
    }

    private static String getDependencyNotation(Collection<Conflict> conflicts) {
        return conflicts.stream().findFirst().map(p -> {
            ModuleVersionIdentifier identifier = p.getVersions().get(0);
            return identifier.getGroup() + ":" + identifier.getName();
        }).orElseThrow(() -> new GradleException("This "));
    }

    private static List<String> createResolutions(String projectPath, String configurationName, String dependencyNotation) {
        if (projectPath.equals(":")) {
            projectPath = "";
        }
        return ImmutableList.of((Object)("Run with " + projectPath + ":dependencyInsight --configuration " + configurationName + " --dependency " + dependencyNotation + " to get more insight on how to solve the conflict."));
    }

    public List<String> getResolutions() {
        return this.resolutions;
    }

    public static VersionConflictException create(String projectPath, String configurationName, Collection<Conflict> conflicts) {
        String message = VersionConflictException.buildMessage(conflicts);
        List<String> resolutions = VersionConflictException.createResolutions(projectPath, configurationName, VersionConflictException.getDependencyNotation(conflicts));
        return new VersionConflictException(message, (Collection<Conflict>)ImmutableList.copyOf(conflicts), resolutions);
    }
}

