/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.HasAttributes;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Cast;
import org.gradle.internal.component.model.AttributeMatcher;
import org.gradle.internal.component.model.AttributeMatchingExplanationBuilder;
import org.gradle.internal.component.model.AttributeSelectionSchema;
import org.gradle.internal.component.model.MultipleCandidateMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAttributeMatcher
implements AttributeMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAttributeMatcher.class);
    private final AttributeSelectionSchema schema;
    private final ConcurrentMap<CachedQuery, int[]> cachedQueries = new ConcurrentHashMap<CachedQuery, int[]>();

    public DefaultAttributeMatcher(AttributeSelectionSchema schema) {
        this.schema = schema;
    }

    @Override
    public AttributeSelectionSchema getSelectionSchema() {
        return this.schema;
    }

    @Override
    public boolean isMatching(AttributeContainerInternal candidate, AttributeContainerInternal requested) {
        if (requested.isEmpty() || candidate.isEmpty()) {
            return true;
        }
        ImmutableAttributes requestedAttributes = requested.asImmutable();
        ImmutableAttributes candidateAttributes = candidate.asImmutable();
        for (Attribute attribute : requestedAttributes.keySet()) {
            AttributeValue requestedValue = requestedAttributes.findEntry(attribute);
            AttributeValue candidateValue = candidateAttributes.findEntry(attribute.getName());
            if (!candidateValue.isPresent()) continue;
            Object coercedValue = candidateValue.coerce(attribute);
            boolean match = this.schema.matchValue(attribute, requestedValue.get(), coercedValue);
            if (match) continue;
            return false;
        }
        return true;
    }

    @Override
    public <T> boolean isMatching(Attribute<T> attribute, T candidate, T requested) {
        return this.schema.matchValue(attribute, requested, candidate);
    }

    @Override
    public List<AttributeMatcher.MatchingDescription<?>> describeMatching(AttributeContainerInternal candidate, AttributeContainerInternal requested) {
        if (requested.isEmpty() || candidate.isEmpty()) {
            return Collections.emptyList();
        }
        ImmutableAttributes requestedAttributes = requested.asImmutable();
        ImmutableAttributes candidateAttributes = candidate.asImmutable();
        ImmutableSet attributes = requestedAttributes.keySet();
        ArrayList result = new ArrayList(attributes.size());
        for (Attribute attribute : attributes) {
            AttributeValue requestedValue = requestedAttributes.findEntry(attribute);
            AttributeValue candidateValue = candidateAttributes.findEntry(attribute.getName());
            if (candidateValue.isPresent()) {
                Object coercedValue = candidateValue.coerce(attribute);
                boolean match = this.schema.matchValue(attribute, requestedValue.get(), coercedValue);
                result.add(new AttributeMatcher.MatchingDescription(attribute, requestedValue, candidateValue, match));
                continue;
            }
            result.add(new AttributeMatcher.MatchingDescription(attribute, requestedValue, candidateValue, false));
        }
        return result;
    }

    @Override
    public <T extends HasAttributes> List<T> matches(Collection<? extends T> candidates, AttributeContainerInternal requested, AttributeMatchingExplanationBuilder explanationBuilder) {
        if (candidates.size() == 0) {
            explanationBuilder.noCandidates(requested);
            return ImmutableList.of();
        }
        if (candidates.size() == 1) {
            HasAttributes candidate = (HasAttributes)candidates.iterator().next();
            if (this.isMatching((AttributeContainerInternal)candidate.getAttributes(), requested)) {
                explanationBuilder.singleMatch(candidate, candidates, requested);
                return Collections.singletonList(candidate);
            }
            explanationBuilder.candidateDoesNotMatchAttributes(candidate, requested);
            return ImmutableList.of();
        }
        ImmutableAttributes requestedAttributes = requested.asImmutable();
        Object candidateList = candidates instanceof List ? (List)Cast.uncheckedCast(candidates) : ImmutableList.copyOf(candidates);
        CachedQuery query = CachedQuery.from(requestedAttributes, candidateList);
        int[] indices = this.cachedQueries.compute(query, (arg_0, arg_1) -> this.lambda$matches$0(explanationBuilder, (List)candidateList, requestedAttributes, requested, arg_0, arg_1));
        return CachedQuery.getMatchesFromCandidateIndices(indices, candidateList);
    }

    private /* synthetic */ int[] lambda$matches$0(AttributeMatchingExplanationBuilder explanationBuilder, List candidateList, ImmutableAttributes requestedAttributes, AttributeContainerInternal requested, CachedQuery key, int[] value) {
        if (value == null || !explanationBuilder.canSkipExplanation()) {
            int[] matches = new MultipleCandidateMatcher(this.schema, candidateList, requestedAttributes, explanationBuilder).getMatches();
            LOGGER.debug("Selected matches {} from candidates {} for {}", new Object[]{Ints.asList((int[])matches), candidateList, requested});
            return matches;
        }
        return value;
    }

    private static class CachedQuery {
        private final ImmutableAttributes requestedAttributes;
        private final ImmutableAttributes[] candidates;
        private final int hashCode;

        private CachedQuery(ImmutableAttributes requestedAttributes, ImmutableAttributes[] candidates) {
            this.requestedAttributes = requestedAttributes;
            this.candidates = candidates;
            this.hashCode = CachedQuery.computeHashCode(requestedAttributes, candidates);
        }

        private static int computeHashCode(ImmutableAttributes requestedAttributes, ImmutableAttributes[] candidates) {
            int hash = requestedAttributes.hashCode();
            for (ImmutableAttributes candidate : candidates) {
                hash = 31 * hash + candidate.hashCode();
            }
            return hash;
        }

        public static <T extends HasAttributes> CachedQuery from(ImmutableAttributes requestedAttributes, List<T> candidates) {
            ImmutableAttributes[] attributes = new ImmutableAttributes[candidates.size()];
            for (int i = 0; i < candidates.size(); ++i) {
                attributes[i] = ((AttributeContainerInternal)((HasAttributes)candidates.get(i)).getAttributes()).asImmutable();
            }
            return new CachedQuery(requestedAttributes, attributes);
        }

        public static <T extends HasAttributes> List<T> getMatchesFromCandidateIndices(int[] indices, List<? extends T> candidates) {
            if (indices.length == 0) {
                return Collections.emptyList();
            }
            ArrayList<HasAttributes> matches = new ArrayList<HasAttributes>(indices.length);
            for (int index : indices) {
                matches.add((HasAttributes)candidates.get(index));
            }
            return matches;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CachedQuery that = (CachedQuery)o;
            return this.hashCode == that.hashCode && this.requestedAttributes.equals(that.requestedAttributes) && Arrays.equals(this.candidates, that.candidates);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return "CachedQuery{requestedAttributes=" + this.requestedAttributes + ", candidates=" + Arrays.toString(this.candidates) + '}';
        }
    }
}

