/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.deprecation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.problems.DocLink;

public abstract class Documentation
implements DocLink {
    public static final String RECOMMENDATION = "For more %s, please refer to %s in the Gradle documentation.";
    private static final DocumentationRegistry DOCUMENTATION_REGISTRY = new DocumentationRegistry();
    public static final Documentation NO_DOCUMENTATION = new NullDocumentation();

    public static Documentation userManual(String id, String section) {
        return new UserGuide(id, section);
    }

    static Documentation userManual(String id) {
        return new UserGuide(id, null);
    }

    static Documentation upgradeGuide(int majorVersion, String upgradeGuideSection) {
        return new UpgradeGuide(majorVersion, upgradeGuideSection);
    }

    public static Documentation dslReference(Class<?> targetClass, String property) {
        return new DslReference(targetClass, property);
    }

    @Nullable
    public String getConsultDocumentationMessage() {
        return String.format(RECOMMENDATION, "information", this.getUrl());
    }

    private static class DslReference
    extends SerializerableDocumentation {
        private final Class<?> targetClass;
        private final String property;

        public DslReference(Class<?> targetClass, String property) {
            this.targetClass = (Class)Preconditions.checkNotNull(targetClass);
            this.property = (String)Preconditions.checkNotNull((Object)property);
        }

        public String getUrl() {
            return DOCUMENTATION_REGISTRY.getDslRefForProperty(this.targetClass, this.property);
        }

        @Override
        Map<String, String> getProperties() {
            return ImmutableMap.of((Object)"property", (Object)this.property, (Object)"targetClass", (Object)this.targetClass.getName());
        }
    }

    private static class UpgradeGuide
    extends UserGuide {
        private UpgradeGuide(int majorVersion, String section) {
            super("upgrading_version_" + majorVersion, section);
        }

        @Override
        public String getConsultDocumentationMessage() {
            return "Consult the upgrading guide for further information: " + this.getUrl();
        }
    }

    private static class UserGuide
    extends SerializerableDocumentation {
        private final String page;
        private final String section;
        private final String topic;

        private UserGuide(String id, @Nullable String section) {
            this.page = (String)Preconditions.checkNotNull((Object)id);
            this.section = section;
            this.topic = null;
        }

        private UserGuide(String topic, String id, @Nullable String section) {
            this.page = (String)Preconditions.checkNotNull((Object)id);
            this.section = section;
            this.topic = topic;
        }

        public String getUrl() {
            if (this.section == null) {
                return DOCUMENTATION_REGISTRY.getDocumentationFor(this.page);
            }
            if (this.topic == null) {
                return DOCUMENTATION_REGISTRY.getDocumentationFor(this.page, this.section);
            }
            return DOCUMENTATION_REGISTRY.getDocumentationRecommendationFor(this.topic, this.page, this.section);
        }

        @Override
        Map<String, String> getProperties() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)"page", (Object)this.page);
            builder.put((Object)"section", (Object)this.section);
            if (this.topic != null) {
                builder.put((Object)"topic", (Object)this.topic);
            }
            return builder.build();
        }
    }

    private static class NullDocumentation
    extends SerializerableDocumentation {
        private NullDocumentation() {
        }

        public String getUrl() {
            return null;
        }

        @Override
        public String getConsultDocumentationMessage() {
            return null;
        }

        @Override
        Map<String, String> getProperties() {
            return ImmutableMap.of();
        }
    }

    public static abstract class AbstractBuilder<T> {
        public abstract T withDocumentation(DocLink var1);

        public T undocumented() {
            return this.withDocumentation(NO_DOCUMENTATION);
        }

        public T withUserManual(String documentationId) {
            return this.withDocumentation(Documentation.userManual(documentationId));
        }

        public T withUserManual(String documentationId, String section) {
            return this.withDocumentation(Documentation.userManual(documentationId, section));
        }

        public T withDslReference(Class<?> targetClass, String property) {
            return this.withDocumentation(Documentation.dslReference(targetClass, property));
        }

        public T withUpgradeGuideSection(int majorVersion, String upgradeGuideSection) {
            return this.withDocumentation(Documentation.upgradeGuide(majorVersion, upgradeGuideSection));
        }
    }

    private static abstract class SerializerableDocumentation
    extends Documentation {
        private SerializerableDocumentation() {
        }

        abstract Map<String, String> getProperties();
    }
}

