/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableSortedMap;
import java.util.Optional;
import javax.annotation.Nullable;
import org.gradle.internal.execution.history.PreviousExecutionState;
import org.gradle.internal.execution.steps.WorkspaceContext;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;

public class PreviousExecutionContext
extends WorkspaceContext {
    private final PreviousExecutionState previousExecutionState;

    public PreviousExecutionContext(WorkspaceContext parent, @Nullable PreviousExecutionState previousExecutionState) {
        super(parent);
        this.previousExecutionState = previousExecutionState;
    }

    public PreviousExecutionContext withInputFiles(final ImmutableSortedMap<String, CurrentFileCollectionFingerprint> inputFiles) {
        return new PreviousExecutionContext(this){

            @Override
            public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getInputFileProperties() {
                return inputFiles;
            }
        };
    }

    protected PreviousExecutionContext(PreviousExecutionContext parent) {
        this(parent, parent.getPreviousExecutionState().orElse(null));
    }

    public Optional<PreviousExecutionState> getPreviousExecutionState() {
        return Optional.ofNullable(this.previousExecutionState);
    }
}

