/*
 * Decompiled with CFR 0.152.
 */
package net.yura.swingme.core;

import java.util.Calendar;
import net.yura.mobile.gui.Font;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.components.Component;

public class AnalogClock
extends Component {
    private double diam = 0.38;
    private double LineLengthSeconds = 0.9;
    private double LineLengthMinutes = 0.75;
    private double LineLengthHour = 0.5;
    private double LineLengthTicks = 0.08;
    private double TextPositionRelativeR = 1.22;
    Font Font;
    Calendar _now;
    boolean drawNumbers;
    boolean drawSecondhand;
    boolean drawTicks;

    private int pointX(double minute, double radius, int _circleCenterX) {
        double angle = minute * Math.PI / 30.0;
        return (int)((double)_circleCenterX + radius * Math.sin(angle));
    }

    private int pointY(double minute, double radius, int oy) {
        double angle = minute * Math.PI / 30.0;
        return (int)((double)oy - radius * Math.cos(angle));
    }

    public void paintComponent(Graphics2D g) {
        int Width = this.getWidth();
        int Height = this.getHeight();
        int size = Math.min(Width, Height);
        int _raduis = (int)(this.diam * (double)size);
        int _circleCenterX = size / 2;
        int _circleCenterY = size / 2;
        g.setColor(this.getForeground());
        g.drawArc(_circleCenterX - _raduis, _circleCenterY - _raduis, _raduis * 2, _raduis * 2, 0, 360);
        g.setFont(this.Font);
        int textH = this.Font.getHeight();
        for (int hour = 1; hour <= 12; ++hour) {
            double angle = (double)hour * 60.0 / 12.0;
            if (this.drawTicks) {
                g.drawLine(this.pointX(angle, (double)_raduis * (1.0 - this.LineLengthTicks), _circleCenterX), this.pointY(angle, (double)_raduis * (1.0 - this.LineLengthTicks), _circleCenterY), this.pointX(angle, _raduis, _circleCenterX), this.pointY(angle, _raduis, _circleCenterY));
            }
            if (!this.drawNumbers) continue;
            int textW = this.Font.getWidth("" + hour);
            g.drawString("" + hour, this.pointX(angle, (double)_raduis * this.TextPositionRelativeR, _circleCenterX) - textW / 2, this.pointY(angle, (double)_raduis * this.TextPositionRelativeR, _circleCenterY) - textH / 2);
        }
        double hour = (double)this._now.get(10) * 60.0 / 12.0;
        double minute = this._now.get(12);
        double second = this._now.get(13);
        g.drawLine(_circleCenterX, _circleCenterY, this.pointX(hour + minute / 12.0, (double)_raduis * this.LineLengthHour, _circleCenterX), this.pointY(hour + minute / 12.0, (double)_raduis * this.LineLengthHour, _circleCenterY));
        g.drawLine(_circleCenterX, _circleCenterY, this.pointX(minute + second / 60.0, (double)_raduis * this.LineLengthMinutes, _circleCenterX), this.pointY(minute + second / 60.0, (double)_raduis * this.LineLengthMinutes, _circleCenterY));
        if (this.drawSecondhand) {
            g.drawLine(_circleCenterX, _circleCenterY, this.pointX(second, (double)_raduis * this.LineLengthSeconds, _circleCenterX), this.pointY(second, (double)_raduis * this.LineLengthSeconds, _circleCenterY));
        }
    }

    public void updateUI() {
        super.updateUI();
        this.Font = this.theme.getFont(0);
    }

    protected String getDefaultName() {
        return "AnalogClock";
    }

    protected void workoutMinimumSize() {
        this.width = 10;
        this.height = 10;
    }

    public void setTime(Calendar time) {
        this._now = time;
    }
}

