/*
 * Decompiled with CFR 0.152.
 */
package net.yura.lobby.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class ByteInputStream
extends InputStream {
    protected byte[][] buf = new byte[0][];
    protected int pos;

    public void addBytes(byte[] newByte) {
        byte[][] newBytes = new byte[this.buf.length + 1][];
        System.arraycopy(this.buf, 0, newBytes, 0, this.buf.length);
        newBytes[this.buf.length] = newByte;
        this.buf = newBytes;
    }

    public final int readInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read()) | (ch3 = this.read()) | (ch4 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public int read() {
        if (this.buf.length == 0) {
            return -1;
        }
        int result = this.buf[0][this.pos++] & 0xFF;
        if (this.pos >= this.buf[0].length) {
            this.pos -= this.buf[0].length;
            byte[][] newBytes = new byte[this.buf.length - 1][];
            System.arraycopy(this.buf, 1, newBytes, 0, newBytes.length);
            this.buf = newBytes;
        }
        return result;
    }

    public long skip(long n) {
        int count = 0;
        int delbuf = 0;
        int delbytes = 0;
        for (int c = 0; c < this.buf.length; ++c) {
            if ((long)this.pos + n < (long)(count += this.buf[c].length)) continue;
            ++delbuf;
            delbytes += this.buf[c].length;
        }
        if ((long)this.pos + n > (long)count) {
            n = count - this.pos;
        }
        if (n < 0L) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + n);
        if (delbuf > 0) {
            byte[][] newBytes = new byte[this.buf.length - delbuf][];
            System.arraycopy(this.buf, delbuf, newBytes, 0, newBytes.length);
            this.buf = newBytes;
            this.pos -= delbytes;
        }
        return n;
    }

    public int available() {
        int count = 0;
        for (int c = 0; c < this.buf.length; ++c) {
            count += this.buf[c].length;
        }
        return count - this.pos;
    }
}

