/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.components;

import javax.microedition.lcdui.Image;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.gui.KeyEvent;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.ScrollPane;

public class ImageView
extends Component {
    private Icon bgImage;
    protected int imgW;
    protected int imgH;
    boolean consumingMotionEvents;
    private int startPinchSize;
    private double startPinchX;
    private double startPinchY;
    private double ratio = 1.0;

    public ImageView() {
        this.focusable = false;
    }

    public void setBackgroundImage(Icon backgroundImage) {
        this.bgImage = backgroundImage;
        if (this.bgImage != null) {
            this.imgW = this.bgImage.getIconWidth();
            this.imgH = this.bgImage.getIconHeight();
        }
    }

    public Icon getBackgroundImage() {
        return this.bgImage;
    }

    protected void workoutMinimumSize() {
        this.width = this.bgImage == null ? 1 : 100;
        this.height = this.bgImage == null ? 1 : 100;
    }

    public boolean consumesMotionEvents() {
        return this.consumingMotionEvents;
    }

    protected double getScale() {
        return Math.min((double)this.getHeight() / (double)this.imgH, (double)this.getWidth() / (double)this.imgW);
    }

    protected int getImgX(double s) {
        return (int)((double)this.getWidth() - (double)this.imgW * s) / 2;
    }

    protected int getImgY(double s) {
        return (int)((double)this.getHeight() - (double)this.imgH * s) / 2;
    }

    public void paintComponent(Graphics2D g) {
        if (this.bgImage != null) {
            double ratio = this.getScale();
            int imgX = this.getImgX(ratio);
            int imgY = this.getImgY(ratio);
            Image img = this.bgImage.getImage();
            if (img == null) {
                this.bgImage.paintIcon(this, g, imgX, imgY);
            } else {
                g.drawScaledImage(img, imgX, imgY, (int)((double)this.imgW * ratio), (int)((double)this.imgH * ratio));
            }
        }
    }

    public void processMouseEvent(int type, int x, int y, KeyEvent keys) {
    }

    public void processMultitouchEvent(int[] type, int[] x, int[] y) {
        boolean bl = this.consumingMotionEvents = type[0] != 2;
        if (type.length >= 2) {
            if (type[0] == 1 || type[1] == 1) {
                this.animateToFit(false);
                this.ratio = this.getScale();
                this.startPinchSize = this.getDistance(x, y);
                int imgX = this.getImgX(this.ratio);
                int imgY = this.getImgY(this.ratio);
                this.startPinchX = (double)((x[0] + x[1]) / 2 - imgX) / this.ratio;
                this.startPinchY = (double)((y[0] + y[1]) / 2 - imgY) / this.ratio;
                this.setLocation(this.posX + imgX, this.posY + imgY);
                this.width = (int)((double)this.imgW * this.ratio);
                this.height = (int)((double)this.imgH * this.ratio);
            } else {
                int pinchSize = this.getDistance(x, y);
                int pinchDiff = pinchSize - this.startPinchSize;
                int newW = (int)((double)this.imgW * this.ratio) + pinchDiff;
                int newH = this.imgH * newW / this.imgW;
                this.width = newW;
                this.height = newH;
                double nratio = this.getScale();
                int endPinchX = (x[0] + x[1]) / 2;
                int endPinchY = (y[0] + y[1]) / 2;
                int difx = (int)(this.startPinchX * nratio - (double)endPinchX);
                int dify = (int)(this.startPinchY * nratio - (double)endPinchY);
                this.setLocation(this.posX - difx, this.posY - dify);
            }
            if (type[0] == 2 || type[1] == 2) {
                this.animateToFit(true);
            }
        }
        Component cmp = this.getParent() == null ? this : this.getParent();
        cmp.repaint();
    }

    private int getDistance(int[] x, int[] y) {
        int dx = x[0] - x[1];
        int dy = y[0] - y[1];
        return (int)Math.sqrt(dx * dx + dy * dy);
    }

    protected String getDefaultName() {
        return "ImageView";
    }

    private void animateToFit(boolean startAnimation) {
        Component sp = this.getParent();
        if (sp instanceof ScrollPane) {
            ((ScrollPane)sp).animateToFit(startAnimation);
        }
    }
}

