/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import net.yura.mobile.io.FileUtil;
import net.yura.mobile.logging.Logger;
import net.yura.mobile.util.QueueProcessorThread;

public abstract class SocketClient
implements Runnable {
    public static final int DISCONNECTED = 1;
    public static final int CONNECTED = 2;
    public static final int CONNECTING = 3;
    public static final int COMMUNICATING = 4;
    public static final int DISCONNECTED_AND_PAUSED = 5;
    protected QueueProcessorThread writeThread;
    private Thread readThread;
    protected Vector offlineBox = new Vector();
    protected StreamConnection conn;
    protected OutputStream out;
    protected InputStream in;
    private boolean disconnected = false;
    protected int maxRetries = 3;
    protected int retryWaitMultiplier = 2;
    protected int initialWaitValue = 1000;
    protected int maxWaitTimeMillis = 30000;
    boolean pauseReconnectOnFailure;
    private int retryCount;
    protected String protocol = "socket://";
    private final String server;
    public static String connectAppend;

    public void setDisconnected(boolean b) {
        this.disconnected = b;
    }

    public SocketClient(String server) {
        this.server = server;
    }

    public SocketClient(String server, int maxRetries, int retryWaitMultiplier, int initialWaitValue, int maxWaitTimeMillis, boolean pauseReconnectOnFailure) {
        this.server = server;
        this.maxRetries = maxRetries;
        this.retryWaitMultiplier = retryWaitMultiplier;
        this.initialWaitValue = initialWaitValue;
        this.maxWaitTimeMillis = maxWaitTimeMillis;
        this.pauseReconnectOnFailure = pauseReconnectOnFailure;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    protected int getRetryCount() {
        return this.retryCount;
    }

    protected int getMaxRetries() {
        return this.maxRetries;
    }

    protected StreamConnection openConnection(String serv) throws IOException {
        if (connectAppend != null && serv.indexOf(";") < 0) {
            serv = serv + connectAppend;
        }
        return (StreamConnection)Connector.open((String)(this.protocol + serv));
    }

    public void addToOutbox(Object obj) {
        if (this.writeThread == null) {
            this.writeThread = new QueueProcessorThread("SocketClient-WriteThread"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void process(Object object) {
                    if (SocketClient.this.conn == null) {
                        int wait = SocketClient.this.initialWaitValue;
                        while (SocketClient.this.out == null || SocketClient.this.in == null) {
                            if (!this.isRunning()) {
                                return;
                            }
                            String serv = null;
                            try {
                                serv = SocketClient.this.getNextServer();
                                SocketClient.this.retryCount++;
                                Logger.info("[SocketClient] Trying to connect to: " + serv + " to send: " + object);
                                if (SocketClient.this.disconnected) {
                                    throw new IOException();
                                }
                                SocketClient.this.conn = SocketClient.this.openConnection(serv);
                                SocketClient.this.out = SocketClient.this.conn.openOutputStream();
                                SocketClient.this.in = SocketClient.this.conn.openInputStream();
                                SocketClient.this.updateState(3);
                                SocketClient.this.retryCount = 0;
                                wait = SocketClient.this.initialWaitValue;
                            }
                            catch (SecurityException s) {
                                SocketClient.this.close(SocketClient.this.conn, SocketClient.this.in, SocketClient.this.out);
                                SocketClient.this.updateState(1);
                                Logger.info("cant connect " + serv, s);
                                SocketClient.this.securityException();
                                return;
                            }
                            catch (Exception x) {
                                SocketClient.this.close(SocketClient.this.conn, SocketClient.this.in, SocketClient.this.out);
                                if (x instanceof IOException) {
                                    Logger.info(x.toString());
                                } else {
                                    Logger.info("cant connect " + serv, x);
                                }
                                if (SocketClient.this.pauseReconnectOnFailure && SocketClient.this.retryCount > SocketClient.this.maxRetries) {
                                    SocketClient.this.updateState(5);
                                    1 var5_7 = this;
                                    synchronized (var5_7) {
                                        try {
                                            this.wait();
                                        }
                                        catch (Exception e) {
                                            Logger.info(null, e);
                                        }
                                    }
                                    SocketClient.this.updateState(1);
                                    SocketClient.this.retryCount = 0;
                                    continue;
                                }
                                SocketClient.this.updateState(1);
                                try {
                                    Thread.sleep(wait);
                                    if ((wait *= SocketClient.this.retryWaitMultiplier) <= SocketClient.this.maxWaitTimeMillis) continue;
                                    wait = SocketClient.this.maxWaitTimeMillis;
                                }
                                catch (InterruptedException ex) {
                                    Logger.info(null, ex);
                                }
                            }
                        }
                        SocketClient.this.connected(SocketClient.this.in, SocketClient.this.out);
                        SocketClient.this.readThread = new Thread((Runnable)SocketClient.this, "SocketClient-ReadThread");
                        SocketClient.this.readThread.start();
                    }
                    try {
                        Logger.info("[SocketClient] sending object: " + object);
                        SocketClient.this.updateState(4);
                        if (SocketClient.this.disconnected) {
                            throw new IOException();
                        }
                        SocketClient.this.write(SocketClient.this.out, object);
                        SocketClient.this.out.flush();
                        SocketClient.this.updateState(2);
                    }
                    catch (Exception ex) {
                        Logger.info("[SocketClient] Exception during a write to socket", ex);
                        SocketClient.this.addToOfflineBox(object, true);
                        SocketClient.this.shutdownConnection();
                    }
                }
            };
            this.updateState(3);
            this.writeThread.start();
        }
        this.writeThread.addToInbox(obj);
    }

    public void addToOfflineBox(Object t, boolean isFront) {
        if (!this.offlineBox.contains(t)) {
            if (isFront) {
                this.offlineBox.insertElementAt(t, 0);
            } else {
                this.offlineBox.addElement(t);
            }
        }
        this.wake();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wake() {
        QueueProcessorThread obj = this.writeThread;
        if (obj != null) {
            QueueProcessorThread queueProcessorThread = obj;
            synchronized (queueProcessorThread) {
                obj.notify();
            }
        }
    }

    public Vector getOfflineBox() {
        return this.offlineBox;
    }

    protected void sendOfflineInboxMessages() {
        Logger.info("[SocketClient] sending offline messages: " + this.offlineBox);
        while (!this.offlineBox.isEmpty()) {
            Object task = this.offlineBox.elementAt(0);
            this.offlineBox.removeElementAt(0);
            this.addToOutbox(task);
        }
    }

    public void disconnect() {
        QueueProcessorThread old = this.writeThread;
        this.writeThread = null;
        this.shutdownConnection();
        if (old != null) {
            old.kill();
        }
    }

    private synchronized void shutdownConnection() {
        if (this.conn == null && this.in == null && this.out == null) {
            return;
        }
        this.updateState(1);
        this.close(this.conn, this.in, this.out);
        this.in = null;
        this.out = null;
        this.conn = null;
        if (this.writeThread != null) {
            Vector inbox = this.writeThread.getInbox();
            for (int c = 0; c < inbox.size(); ++c) {
                this.addToOfflineBox(inbox.elementAt(c), false);
            }
            this.writeThread.clearInbox();
            this.disconnected();
        }
    }

    private void close(final StreamConnection connection, final InputStream inputStream, final OutputStream outputStream) {
        new Thread(){

            public void run() {
                FileUtil.close(inputStream);
                FileUtil.close(outputStream);
                FileUtil.close(connection);
            }
        }.start();
    }

    public final void run() {
        try {
            String name = this.readThread.getName();
            int id = System.identityHashCode(this.readThread);
            Logger.info("[SocketClient] STARTING " + name + " " + id);
            if (QueueProcessorThread.CHANGE_PRIORITY) {
                Thread.currentThread().setPriority(1);
            }
            InputStream myin = this.in;
            try {
                while (true) {
                    if (this.disconnected) {
                        throw new IOException();
                    }
                    Object task = this.read(myin);
                    this.updateState(4);
                    Logger.info("[SocketClient] got object: " + task + " " + id);
                    try {
                        Thread.yield();
                        Thread.sleep(0L);
                        this.handleObject(task);
                        Thread.yield();
                        Thread.sleep(0L);
                    }
                    catch (Exception x) {
                        Logger.warn("[SocketClient] CAN NOT HANDLE! Task: " + task + " " + x.toString(), x);
                    }
                    this.updateState(2);
                }
            }
            catch (Exception ex) {
                boolean normal;
                Logger.info("[SocketClient] Disconnect (Exception) during read from socket " + ex.toString() + " " + id);
                boolean bl = normal = myin == this.in;
                if (!(ex instanceof IOException) || !normal && this.writeThread != null) {
                    Logger.warn("[SocketClient] strange disconnect in=" + this.in + " myin=" + myin, ex);
                }
                if (normal) {
                    this.shutdownConnection();
                }
                Logger.info("[SocketClient] ENDING " + name + " " + id);
            }
        }
        catch (Throwable t) {
            Logger.error(null, t);
        }
    }

    protected String getNextServer() {
        return this.server;
    }

    protected void securityException() {
        Logger.warn("[SocketClient] Socket connections are not allowed.");
    }

    protected abstract void handleObject(Object var1);

    protected abstract void updateState(int var1);

    protected abstract void write(OutputStream var1, Object var2) throws IOException;

    protected abstract Object read(InputStream var1) throws IOException;

    protected abstract void connected(InputStream var1, OutputStream var2);

    protected abstract void disconnected();
}

