/*
 * Decompiled with CFR 0.152.
 */
package org.me4se.launcher;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.ApplicationManager;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import org.me4se.JadFile;

public class MIDletLauncher
extends MIDlet
implements CommandListener {
    File currentDir = new File(".");
    List fileList;
    Display display;
    Command cmdBack = new Command("Back", 2, 0);
    Command cmdExit = new Command("Exit", 7, 0);
    int level = 0;
    private static final Class[] parameters = new Class[]{URL.class};

    public static void addFile(String s) throws IOException {
        MIDletLauncher.addFile(new File(s));
    }

    public static void addFile(File f) throws IOException {
        MIDletLauncher.addURL(f.toURL());
    }

    public static void addURL(URL u) throws IOException {
        System.out.println("Adding URL to CP: " + u);
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", parameters);
            method.setAccessible(true);
            method.invoke((Object)sysloader, u);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IOException("Error, could not add URL to system classloader");
        }
    }

    boolean checkDir(File dir) {
        if (!dir.isDirectory()) {
            return dir.getName().endsWith(".jad");
        }
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (!this.checkDir(files[i])) continue;
            return true;
        }
        return false;
    }

    public void open(String target) {
        System.out.println("opening: " + this);
        File toOpen = new File(this.currentDir, target);
        if (toOpen.isDirectory()) {
            this.fileList = new List(toOpen.getAbsoluteFile().getName(), 3);
            File[] files = toOpen.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!this.checkDir(files[i])) continue;
                this.fileList.append(files[i].getName(), null);
            }
            this.fileList.setCommandListener(this);
            this.display.setCurrent(this.fileList);
            this.currentDir = toOpen;
            if (this.fileList.size() == 1 && this.fileList.getString(0).endsWith(".jad")) {
                this.open(this.fileList.getString(0));
            } else {
                this.fileList.addCommand(this.cmdExit);
                if (this.level > 0) {
                    this.fileList.addCommand(this.cmdBack);
                }
            }
        } else {
            this.openJad(toOpen);
        }
    }

    void openJad(File file) {
        JadFile jadFile = new JadFile();
        File dir = file.getParentFile();
        try {
            jadFile.load("file:///" + file.getAbsolutePath());
            Properties props = System.getProperties();
            props.put("rms.home", dir);
            System.setProperties(props);
            String fileName = jadFile.getValue("MIDlet-Jar-URL");
            int lastSlash = fileName.lastIndexOf(47);
            if (lastSlash != -1) {
                fileName = fileName.substring(lastSlash + 1);
            }
            MIDletLauncher.addFile(new File(dir, fileName));
            ApplicationManager.getInstance().launch(jadFile, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void destroyApp(boolean unconditional) throws MIDletStateChangeException {
    }

    protected void pauseApp() {
    }

    protected void startApp() throws MIDletStateChangeException {
        this.display = Display.getDisplay(this);
        this.open(".");
    }

    public void commandAction(Command cmd, Displayable d) {
        if (cmd == this.cmdBack) {
            this.open("..");
            --this.level;
        } else if (cmd == this.cmdExit) {
            this.notifyDestroyed();
        } else {
            ++this.level;
            this.open(this.fileList.getString(this.fileList.getSelectedIndex()));
        }
    }
}

