/*
 * Decompiled with CFR 0.152.
 */
package org.me4se.psi.java1.gcf.datagram;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.microedition.io.Datagram;

public class DatagramImpl
implements Datagram {
    int rwPointer = 0;
    byte[] data;
    int length;
    int offset;
    String address;

    public DatagramImpl(byte[] buf, int size, String addr) throws IOException {
        this.data = buf;
        this.length = size;
        this.address = addr;
    }

    public String getAddress() {
        try {
            return this.address;
        }
        catch (Exception e) {
            return null;
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setAddress(String addr) throws IOException {
        this.address = addr;
    }

    public void setAddress(Datagram reference) {
        try {
            this.setAddress(reference.getAddress());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setLength(int len) {
        this.length = len;
    }

    public void setData(byte[] buffer, int offset, int len) {
        System.arraycopy(buffer, offset, this.data, 0, len);
    }

    DatagramPacket getPacket() throws UnknownHostException {
        String host;
        int cut = this.address.lastIndexOf(58);
        int port = -1;
        if (cut >= 11) {
            host = this.address.substring(11, cut);
            port = Integer.parseInt(this.address.substring(cut + 1));
        } else {
            host = this.address.substring(11);
            port = -1;
        }
        DatagramPacket dp = new DatagramPacket(this.data, this.offset, this.length);
        dp.setAddress(InetAddress.getByName(host));
        if (port != -1) {
            dp.setPort(port);
        }
        return dp;
    }

    InetAddress getInetAddress() throws UnknownHostException {
        int cut = this.address.lastIndexOf(58);
        return InetAddress.getByName(this.address.substring(12, cut));
    }

    public void reset() {
        this.rwPointer = 0;
        this.offset = 0;
        this.length = 0;
    }

    public boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    public byte readByte() throws IOException {
        return this.data[this.rwPointer++];
    }

    public char readChar() throws IOException {
        return (char)(this.readByte() << 8 | this.readByte() & 0xFF);
    }

    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(this.data, 0, b, off, len);
        this.rwPointer += len;
    }

    public int readInt() throws IOException {
        return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
    }

    public long readLong() throws IOException {
        return (long)(this.readByte() & 0xFF) << 56 | (long)(this.readByte() & 0xFF) << 48 | (long)(this.readByte() & 0xFF) << 40 | (long)(this.readByte() & 0xFF) << 32 | (long)(this.readByte() & 0xFF) << 24 | (long)(this.readByte() & 0xFF) << 16 | (long)(this.readByte() & 0xFF) << 8 | (long)(this.readByte() & 0xFF);
    }

    public short readShort() throws IOException {
        return (short)(this.readByte() << 8 | this.readByte() & 0xFF);
    }

    public int readUnsignedByte() throws IOException {
        return this.data[this.rwPointer++];
    }

    public int readUnsignedShort() throws IOException {
        return (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
    }

    public String readUTF() throws IOException {
        short len = this.readShort();
        byte[] buf = new byte[len];
        this.readFully(buf);
        return new String(buf, "utf8");
    }

    public int skipBytes(int n) {
        this.rwPointer += n;
        return n;
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) {
        System.arraycopy(b, off, this.data, this.rwPointer, len);
        this.rwPointer += len;
    }

    public void write(int b) throws IOException {
        this.writeByte((byte)(0xFF & b >> 24));
        this.writeByte((byte)(0xFF & b >> 16));
        this.writeByte((byte)(0xFF & b >> 8));
        this.writeByte((byte)(0xFF & b));
    }

    public void writeBoolean(boolean v) throws IOException {
        if (v) {
            this.writeByte(1);
        } else {
            this.writeByte(0);
        }
    }

    public void writeByte(int v) throws IOException {
        this.writeByte((byte)v);
    }

    public void writeChar(int v) throws IOException {
        this.writeByte((byte)(0xFF & v >> 8));
        this.writeByte((byte)(0xFF & v));
    }

    public void writeChars(String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            this.writeChar(s.charAt(i));
        }
    }

    public void writeInt(int v) throws IOException {
        this.writeByte((byte)(0xFF & v >> 24));
        this.writeByte((byte)(0xFF & v >> 16));
        this.writeByte((byte)(0xFF & v >> 8));
        this.writeByte((byte)(0xFF & v));
    }

    public void writeLong(long v) throws IOException {
        this.writeByte((byte)(0xFFL & v >> 48));
        this.writeByte((byte)(0xFFL & v >> 40));
        this.writeByte((byte)(0xFFL & v >> 32));
        this.writeByte((byte)(0xFFL & v >> 24));
        this.writeByte((byte)(0xFFL & v >> 16));
        this.writeByte((byte)(0xFFL & v >> 8));
        this.writeByte((byte)(0xFFL & v));
    }

    public void writeShort(int v) throws IOException {
        this.writeByte((byte)(0xFF & v >> 8));
        this.writeByte((byte)(0xFF & v));
    }

    public void writeUTF(String str) throws IOException {
        byte[] buf = str.getBytes("utf8");
        this.writeShort(buf.length);
        this.write(buf);
    }

    public float readFloat() {
        throw new RuntimeException("Datagram.readFloat() not yet implemented.");
    }

    public double readDouble() {
        throw new RuntimeException("Datagram.readDouble() not yet implemented.");
    }

    public String readLine() {
        throw new RuntimeException("Datagram.readLine() not yet implemented.");
    }

    public void writeFloat(float f) {
        throw new RuntimeException("Datagram.writeFloat() not yet implemented.");
    }

    public void writeDouble(double d) {
        throw new RuntimeException("Datagram.writeDouble() not yet implemented.");
    }

    public void writeBytes(String s) {
        throw new RuntimeException("Datagram.writeBytes() not yet implemented.");
    }
}

