/*
 * Decompiled with CFR 0.152.
 */
package net.yura.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.JDialog;
import javax.swing.event.MouseInputListener;

class TableSize
extends JDialog
implements MouseInputListener,
WindowFocusListener {
    private Dimension dimension;
    private ActionListener actionlistener;

    public TableSize() {
        this.setBounds(0, 0, 100, 100);
        this.setBackground(Color.WHITE);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addWindowFocusListener(this);
        this.setUndecorated(true);
    }

    public void mouseDragged(MouseEvent e) {
        Dimension d2;
        int y;
        int x = e.getX();
        if (x < 0) {
            x = 0;
        }
        if ((y = e.getY()) < 0) {
            y = 0;
        }
        if (x > this.getWidth()) {
            this.setSize(this.getWidth() + 10, this.getHeight());
        }
        if (y > this.getHeight()) {
            this.setSize(this.getWidth(), this.getHeight() + 10);
        }
        if (!(d2 = new Dimension(x / 10 + 1, y / 10 + 1)).equals(this.dimension)) {
            this.dimension = d2;
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void paint(Graphics g) {
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.BLUE);
        g.fillRect(0, 0, this.dimension.width * 10, this.dimension.height * 10);
        g.setColor(Color.BLACK);
        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        int width = this.getWidth() / 10;
        int height = this.getHeight() / 10;
        for (int x = 1; x < width; ++x) {
            g.drawLine(x * 10, 0, x * 10, height * 10);
        }
        for (int y = 1; y < height; ++y) {
            g.drawLine(0, y * 10, width * 10, y * 10);
        }
        g.setColor(Color.WHITE);
        g.drawString("(" + this.dimension.width + "," + this.dimension.height + ")", this.dimension.width * 5 - 10, this.dimension.height * 5 + 5);
    }

    public void showPopup() {
        this.dimension = new Dimension(3, 3);
        this.setVisible(true);
    }

    public void addActionListener(ActionListener l) {
        this.actionlistener = l;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void windowGainedFocus(WindowEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        this.setVisible(false);
        if (e.getX() > 0 && e.getY() > 0) {
            this.actionlistener.actionPerformed(new ActionEvent(this, 0, "yuratable"));
        }
    }

    public void windowLostFocus(WindowEvent e) {
        this.setVisible(false);
    }

    public Dimension getTableSize() {
        return this.dimension;
    }
}

