/*
 * Decompiled with CFR 0.152.
 */
package net.yura.translation;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTree;
import net.yura.swing.YuraTextEditor;
import net.yura.translation.Mtcomm;
import net.yura.translation.MyNode;
import net.yura.translation.PartnerNode;

public class DoublePanel
extends JPanel
implements ActionListener {
    private JLabel name;
    private PartnerNode partner;
    private Mtcomm mycomm;
    private MyNode message;
    private JTree tree;
    private YuraTextEditor top;
    private YuraTextEditor bottom;
    private Locale localetop;
    private Locale localebottom;

    public DoublePanel(JTree t) {
        this.tree = t;
        this.setLayout(new BorderLayout());
        this.name = new JLabel();
        this.top = new YuraTextEditor();
        this.bottom = new YuraTextEditor(){

            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (DoublePanel.this.bottom.isEditMode()) {
                    String string = String.valueOf(DoublePanel.this.localebottom);
                    g.setFont(this.getFont().deriveFont(100.0f));
                    g.setColor(new Color(-2236963));
                    g.drawString(string, (this.getWidth() - g.getFontMetrics().stringWidth(string)) / 2, (this.getHeight() - g.getFontMetrics().getHeight()) / 2 + g.getFontMetrics().getHeight());
                }
            }
        };
        this.addButtons(this.top);
        this.addButtons(this.bottom);
        this.top.addActionListener(this);
        this.bottom.addActionListener(this);
        this.top.setLabel("default");
        JPanel box2 = new JPanel(new GridLayout(2, 1, 10, 10));
        box2.add(this.top);
        box2.add(this.bottom);
        box2.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.add((Component)this.name, "North");
        this.add(box2);
    }

    private void addButtons(YuraTextEditor ytp) {
        JButton save = new JButton("Save");
        save.setActionCommand("save");
        JButton revert = new JButton("Revert");
        revert.setActionCommand("revert");
        JButton reload = new JButton("Reload");
        reload.setActionCommand("reload");
        JButton setnull = new JButton("Remove");
        setnull.setActionCommand("setnull");
        ytp.add(save);
        ytp.add(revert);
        ytp.add(reload);
        ytp.add(setnull);
    }

    public void reuse(MyNode a, PartnerNode p, Locale l1, Locale l2, Mtcomm com) throws Exception {
        this.name.setText("<html><b>&nbsp;&nbsp;" + a.getName() + " (" + p + ")</b></html>");
        this.partner = p;
        this.mycomm = com;
        this.message = a;
        this.localetop = l1;
        this.top.setText(this.message.getMessage(this.mycomm, this.partner, this.localetop));
        this.resetLocale(l2);
    }

    public void resetLocale(Locale a) throws Exception {
        this.localebottom = a;
        this.bottom.setLabel("in " + this.localebottom);
        this.bottom.setTextLocale(this.localebottom);
        this.bottom.setText(this.message.getMessage(this.mycomm, this.partner, this.localebottom));
    }

    public void revert() {
        this.top.revert();
        this.bottom.revert();
    }

    public PartnerNode getID() {
        return this.partner;
    }

    public boolean checkChange() {
        return this.top.checkChange() || this.bottom.checkChange();
    }

    public void saveChanges() throws Exception {
        this.saveChanges(this.top);
        this.saveChanges(this.bottom);
    }

    public void setWrap(boolean a) {
        this.top.setWrap(a);
        this.bottom.setWrap(a);
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals("reload")) {
            try {
                if (ae.getSource() == this.top) {
                    this.message.reload(this.mycomm, this.partner, this.localetop);
                    this.top.setText(this.message.getMessage(this.mycomm, this.partner, this.localetop));
                } else if (ae.getSource() == this.bottom) {
                    this.message.reload(this.mycomm, this.partner, this.localebottom);
                    this.bottom.setText(this.message.getMessage(this.mycomm, this.partner, this.localebottom));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.showError("unable to reload: " + e.getMessage());
            }
        } else if (ae.getActionCommand().equals("revert")) {
            ((YuraTextEditor)ae.getSource()).revert();
        } else if (ae.getActionCommand().equals("save")) {
            try {
                this.saveChanges((YuraTextEditor)ae.getSource());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.showError("unable to save: " + e.getMessage());
            }
            this.tree.repaint();
        } else if (ae.getActionCommand().equals("setnull")) {
            try {
                if (ae.getSource() == this.top) {
                    this.message.saveMessage(this.mycomm, this.partner, this.localetop, null, this.localebottom);
                    this.top.setText(null);
                } else if (ae.getSource() == this.bottom) {
                    this.message.saveMessage(this.mycomm, this.partner, this.localebottom, null, this.localebottom);
                    this.bottom.setText(null);
                }
                this.tree.repaint();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.showError("unable to set to null: " + e.getMessage());
            }
        } else {
            throw new RuntimeException("unknown command " + ae.getActionCommand());
        }
    }

    public void showError(String a) {
        JOptionPane.showMessageDialog(this, a, "error!", 0);
    }

    public void saveChanges(YuraTextEditor a) throws Exception {
        if (a.checkChange()) {
            this.message.saveMessage(this.mycomm, this.partner, a == this.top ? this.localetop : this.localebottom, a.getText(), this.localebottom);
            a.setText(a.getText());
        }
    }
}

